% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect}
\alias{effect}
\title{Effect estimation in dynamic path analysis}
\usage{
effect(formula, object, alpha = 0.05)
}
\arguments{
\item{formula}{the formula for the direct or indirect effect to be estimated. Should be of the form: covariate ~ outcome for direct effect of covariate on outcome, while it
should be of the form: covariate ~ mediator ~ outcome for indirect effect of covariate on outcome mediated through mediator.
Note that the word "outcome" is reserved for the survival outcome process, but the word "covariate" and "mediator" should match a corresponding variable name in the data input.
Alternatively the form can be: covariate ~ mediator for direct effects of covariate on mediator, or: covariate ~ mediator1 ~ mediator2
for indirect effects of covariate on mediator2 mediated through mediator1.}

\item{object}{object of class "dpa" (as obtained by calling the function \code{dpa}) from which the effect is to be estimated.}

\item{alpha}{The confidence level of the bootstrap intervals}
}
\value{
object of class "effect" with following fields:
\describe{
\item{coefs}{data.frame containing the unique event times along with the calculated effect coefficients. For effects corresponding to a continuous variable this results in a
single effect column. For factors with n.levels categories the data.frame contains n.levels-1 effect columns each representing the effect coefficient of a particular factor level (as compared to reference level).}
\item{lower}{data.frame of same dimension as coefs containing the lower confidence bands of the effects stored in coefs}
\item{upper}{data.frame of same dimension as coefs containing the upper confidence bands of the effects stored in coefs}
\item{boot.coefs}{data.frame with three columns: one column of bootstrap sample ID, a second column of unique event times (per bootstrap sample), and
a third column of the estimated effect coefficients (per bootstrap sample). The storing of the effects per bootstrap sample
facilitates calculation of bootstrap confidence intervals for sums of indirect and direct effects.}
\item{label}{effect label with path specification: "direct" for direct effect and "indirect" for indirect effect mediated through a path of mediator(s)}
\item{scale}{scale of effect coefficients in coefs, lower, upper: "cumulative" (for effects on outcome) or "identity" (for effects on mediators)}
\item{alpha}{confidence level of the bootstrap intervals}
}
}
\description{
effect estimation method for class "dpa"
}
\examples{
library(dpasurv)

data(simdata)

set.seed(1)

# Perform dynamic path analysis:
# We set boot.n=30 for the example to run fast, should be set large enough
# so that results don't change meaningfully for different seeds.
s <- dpa(Surv(start,stop,event)~M+x, list(M~x), id="subject", data=simdata, boot.n=30)

direct <- effect(x ~ outcome, s)
indirect <- effect(x ~ M ~ outcome, s)
total <- sum(direct, indirect)

}
