% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qdpcr.R
\name{plot.qdpcr}
\alias{plot.qdpcr}
\alias{plot,qdpcr-method}
\alias{plot,qdpcr,ANY-method}
\title{Plot \code{qdpcr} objects}

\arguments{
\item{x}{is a \code{\linkS4class{qdpcr}} object.}
\item{mincyc}{is the first cycle to start the plot from.}
\item{maxcyc}{the last cycle for the plot.}
\item{rug}{Adds a rug representation of the data to the plot.}
\item{digits}{how many significant digits are to be used in plot.}
}

\value{The plot.}

\description{
An analytical plot describing relationship between the cycle number and the
current value of Poisson mean. The plot can be used for quality control of
process.
}
\details{
The \code{rug} parameter allows user to add density of the number of events
to the plot.
}
\examples{

library(qpcR)
test <- cbind(reps[1L:45, ], reps2[1L:45, 2L:ncol(reps2)], reps3[1L:45, 
        2L:ncol(reps3)])
        
plot(qpcr2pp(data = test, cyc = 1, fluo = NULL, model = l5, delta = 5), rug = TRUE)

}
\seealso{
\code{\linkS4class{qdpcr}}
}
\author{
Stefan Roediger, Michal Burdukiewicz
}
\keyword{hplot}
