% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adpcr2ppp.R
\name{adpcr2ppp}
\alias{adpcr2ppp}
\title{Convert adpcr to ppp}
\usage{
adpcr2ppp(input, marks = TRUE, plot = FALSE)
}
\arguments{
\item{input}{Object of the \code{\linkS4class{adpcr}} class containing data
from one or more panels.}

\item{marks}{If \code{TRUE}, marks values for non-empty partitions. See 
\code{ppp} for more in-depth description.}

\item{plot}{If \code{TRUE}, array is plotted.}
}

\value{
A list containing objects with class
\code{ppp.object} with the length equal to the number of
arrays (minimum 1).
}
\description{
Converts \code{\linkS4class{adpcr}} object to the list of
\code{ppp.object}s.
}
\details{
Each array is independently converted by \code{ppp}
function. \code{marks} attached to each point represent values contained by
the \code{\linkS4class{adpcr}} object.
}
\examples{

many_panels <- sim_adpcr(m = 400, n = 765, times = 1000, pos_sums = FALSE, 
                   n_panels = 5)

# Convert all arrays to ppp objects
adpcr2ppp(many_panels)

# Convert all arrays to ppp objects and get third plate
third_plate <- adpcr2ppp(many_panels)[[3]]

# Convert only third plate to ppp object
third_plate2 <- adpcr2ppp(extract_run(many_panels, 3))

# Check the class of a new object
class(third_plate2)

# It's a list with the length 1. The third plate is a first element on this 
#list
class(third_plate2[[1]])

}
\author{
Michal Burdukiewcz, Stefan Roediger.
}
\keyword{manip}
\keyword{panel}
