% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twomode_Density.R
\name{computeTMDens}
\alias{computeTMDens}
\title{Compute Level-Specific Graph Density for Two-Mode Networks}
\usage{
computeTMDens(net, binary = FALSE, level1 = TRUE)
}
\arguments{
\item{net}{A two-mode adjacency matrix.}

\item{binary}{TRUE/FALSE. TRUE indicates that the transposed matrices will be binarized (see Wasserman and Faust 1995: 316). FALSE indicates that the transposed matrices will not be binarized. Set to FALSE by default.}

\item{level1}{TRUE/FALSE. TRUE indicates that the graph density will be computed for level 1 nodes. FALSE indicates that the graph density will be computed for level 2 nodes. Set to FALSE by default.}
}
\value{
The level-specific network density for the two-mode graph.
}
\description{
This function computes the density of a two-mode network following
Wasserman and Faust (1994) and Knoke and Yang (2020). The density is computed
based on the specified level. That is, in an affiliation matrix, density
can be computed on the symmetric \emph{g x g} matrix of co-membership for the
level 1 actors or on the symmetric \emph{h x h} matrix of shared actors for level 2
groups.
}
\details{
Following Wasserman and Faust (1994) and Knoke and Yang (2020), the computation
of density for two-mode networks is level specific. A two-mode matrix \emph{X} with
dimensions \emph{g x h}, where \emph{g} is the number of level 1 nodes (e.g., medical doctors)
and \emph{h} is the number of level 2 nodes (i.e., hospitals). If
the function is defined on the level 1 nodes, the density is computed as:

\deqn{ X^{g} = XX^{T} }
\deqn{ D^{g} = \frac{\sum_{i = 1}^{g}\sum_{j = 1}^{g} x_{ij}^{g} }{g(g-1)}}
In contrast, if it is defined on the level 2 nodes, the density is:
\deqn{ X^{h} = X^{T}X }
\deqn{ D^{h} = \frac{\sum_{i = 1}^{h}\sum_{j = 1}^{h} x_{ij}^{h} }{h(h-1)}}

Moreover, as discussed in Wasserman and Faust (1994: 316), the density can be
based on the dichotomous relations instead of the shared membership values.
This can be specified by \emph{binary = TRUE}.
}
\examples{
#Replicating the biparitate graph presented in Knoke and Yang (2020: 109)
knoke_yang_PC <- matrix(c(1,1,0,0, 1,1,0,0,
                          1,1,1,0, 0,0,1,1,
                          0,0,1,1), byrow = TRUE,
                          nrow = 5, ncol = 4)
colnames(knoke_yang_PC) <- c("Rubio-R","McConnell-R", "Reid-D", "Sanders-D")
rownames(knoke_yang_PC) <- c("UPS", "MS", "HD", "SEU", "ANA")
#compute two-mode density for level 1
#note: this value does not match that of Knoke and Yang (which we believe
#is a typo in that book), but does match that of Wasserman and
#Faust (1995: 317) for the ceo dataset.
computeTMDens(knoke_yang_PC, level1 = TRUE)
#compute two-mode density for level 2.
#note: this value matches that of the book
computeTMDens(knoke_yang_PC, level1 = FALSE)

}
\references{
Wasserman, Stanley and Katherine Faust. 1994. \emph{Social Network Analysis: Methods
and Applications}. Cambridge University Press.

Knoke, David and Song Yang. 2020. \emph{Social Network Analysis}. Sage: Quantitative
Applications in the Social Sciences (154).
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
