% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_comparison}
\alias{plot_comparison}
\alias{plot_comparison.default}
\alias{plot_comparison.dreamer_bma}
\title{Compare Posterior Fits}
\usage{
plot_comparison(..., doses, times, probs, data, n_smooth, width)

\method{plot_comparison}{default}(
  ...,
  doses = attr(list(...)[[1]], "doses"),
  times = NULL,
  probs = c(0.025, 0.975),
  data = NULL,
  n_smooth = 50,
  width = bar_width(doses)
)

\method{plot_comparison}{dreamer_bma}(
  ...,
  doses = x$doses,
  times = NULL,
  probs = c(0.025, 0.975),
  data = NULL,
  n_smooth = 50,
  width = bar_width(doses)
)
}
\arguments{
\item{...}{\code{dreamer_mcmc} objects to be used for plotting.}

\item{doses}{a vector of doses at which to plot the dose response curve.}

\item{times}{the times at which to do the comparison.}

\item{probs}{quantiles of the posterior to be calculated.}

\item{data}{a dataframe with column names of "dose" and "response" for
individual patient data.  Optional columns "n" and "sample_var" can
be specified if aggregate data is supplied, but it is recommended that
patient-level data be supplied where possible for continuous models, as the
posterior weights differ if aggregated data is used.
For aggregated continuous
data, "response" should be the average of "n" subjects with a sample
variance of "sample_var".  For aggregated binary data, "response" should
be the number of successes, "n" should be the total number of subjects
(the "sample_var" column is irrelevant in binary cases and is ignored).}

\item{n_smooth}{the number of points to calculate the smooth dose response
interpolation.  Must be sufficiently high to accurately depict the
dose response curve.}

\item{width}{the width of the error bars.}
}
\value{
a ggplot object.
}
\description{
Compare Posterior Fits
}
\details{
If a Bayesian model averaging object is supplied first, all
individual fits and the Bayesian model averaging fit will be plotted, with
the model averaging fit in black (other model colors specified in the
legend).  Otherwise,
named arguments must be supplied for each model, and only the models
provided will be plotted.
}
\examples{
set.seed(888)
data <- dreamer_data_linear(
  n_cohorts = c(20, 20, 20),
  dose = c(0, 3, 10),
  b1 = 1,
  b2 = 3,
  sigma = 5
)

# Bayesian model averaging
output <- dreamer_mcmc(
 data = data,
 n_adapt = 1e3,
 n_burn = 1e3,
 n_iter = 1e3,
 n_chains = 2,
 silent = FALSE,
 mod_linear = model_linear(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 ),
 mod_quad = model_quad(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   mu_b3 = 0,
   sigma_b3 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 )
)

plot_comparison(output)

# compare individual models
plot_comparison(linear = output$mod_linear, quad = output$mod_quad)
}
