% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmle.R
\name{tmle}
\alias{tmle}
\title{Returns the targeted maximum likelihood estimates for the nuisance functions}
\usage{
tmle(
  datmat,
  iter = 250,
  margin = 0.005,
  stop_margin = 0.005,
  twolist = FALSE,
  K = 2,
  ...
)
}
\arguments{
\item{datmat}{The data frame containing columns \code{yj}, \code{yk}, \code{yjk}, \code{q10}, \code{q02} and \code{q12}.}

\item{iter}{An integer denoting the maximum number of iterations allowed for targeted maximum likelihood method. Default value is 100.}

\item{margin}{The minimum value the estimates can attain to bound them away from zero.}

\item{stop_margin}{The minimum value the estimates can attain to bound them away from zero.}

\item{twolist}{The logical value of whether targeted maximum likelihood algorithm fits only two modes when K = 2.}

\item{K}{The number of lists in the original data.}

\item{...}{Any extra arguments passed into the function.}
}
\value{
A list of estimates containing the following components:
\item{error}{  An indicator of whether the algorithm ran and converged. Returns FALSE, if it ran correctly and FALSE otherwise.}
\item{datmat}{  A data frame returning \code{datmat} with the updated estimates for the nuisance functions \code{q10}, \code{q02} and \code{q12}. This is returned only if \code{error} is FALSE.}
}
\description{
Returns the targeted maximum likelihood estimates for the nuisance functions
}
\examples{
data = matrix(sample(c(0,1), 2000, replace = TRUE), ncol = 2)
xmat = matrix(runif(nrow(data)*3, 0, 1), nrow = nrow(data))
datmat = cbind(data, data[,1]*data[,2], xmat)
colnames(datmat) = c("yj", "yk", "yjk", "q10", "q02", "q12")
datmat = as.data.frame(datmat)
result = tmle(datmat, margin = 0.005, stop_margin = 0.00001, twolist = TRUE)
}
\references{
van der Laan, M. J. and Rubin, D. (2006). Targeted maximum likelihood learning. \emph{The International Journal of Biostatistics}, \emph{2}(1)

Das, M., Kennedy, E. H., & Jewell, N.P. (2021). Doubly robust capture-recapture methods for estimating population size. \emph{arXiv preprint} arXiv:2104.14091.
}
