% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dose_draw.R
\name{f_dose_draw_t_1}
\alias{f_dose_draw_t_1}
\title{Drug Dispensing Visit Dates Simulation for One Iteration}
\usage{
f_dose_draw_t_1(
  i,
  k0_fit,
  t0_fit,
  t1_fit,
  ki_fit,
  ti_fit,
  vf_ongoing1,
  vf_new1
)
}
\arguments{
\item{i}{The iteration number.}

\item{k0_fit}{The model fit for the number of skipped
visits between randomization and the first drug dispensing visit.}

\item{t0_fit}{The model fit for the gap time between randomization
and the first drug dispensing visit when there is no visit skipping.}

\item{t1_fit}{The model fit for the gap time between randomization
and the first drug dispensing visit when there is visit skipping.}

\item{ki_fit}{The model fit for the number of skipped
visits between two consecutive drug dispensing visits.}

\item{ti_fit}{The model fit for the gap time between two
consecutive drug dispensing visits.}

\item{vf_ongoing1}{A data frame for the last observed drug dispensing
date for ongoing patients with drug dispensing records.
For the common time model, it includes the following variables:
\code{draw}, \code{usubjid}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, \code{totalTime},
\code{V}, \code{C}, and \code{D}.
For separate time models, it includes the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{arrivalTime}, \code{treatment}, \code{treatment_description},
\code{time}, \code{totalTime}, \code{V}, \code{C}, and \code{D}.}

\item{vf_new1}{A data frame for the randomization date for new patients
and ongoing patients with no drug dispensing records.
For the common time model, it includes the following variables:
\code{draw}, \code{usubjid}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, \code{totalTime},
\code{V}, \code{C}, and \code{D}.
For separate time models, it includes the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{arrivalTime}, \code{treatment}, \code{treatment_description},
\code{time}, \code{totalTime}, \code{V}, \code{C}, and \code{D}.}
}
\value{
A data frame containing the simulated drug dispensing visit
dates at the subject level for ongoing and new subjects. It includes
the following variables:
\code{usubjid}, \code{day}, \code{draw}, \code{arrivalTime},
\code{treatment}, \code{treatment_description}, \code{time},
\code{totalTime}, and \code{status}.
}
\description{
Simulates drug dispensing visit dates for one iteration.
}
\examples{

\donttest{
set.seed(431)
library(dplyr)

pred <- eventPred::getPrediction(
  df = df2,
  to_predict = "event only",
  target_d = 250,
  event_model = "log-logistic",
  dropout_model = "none",
  pilevel = 0.95,
  nyears = 3,
  nreps = 200,
  showsummary = FALSE,
  showplot = FALSE,
  by_treatment = TRUE)

observed <- f_dose_observed(df2, visitview2, showplot = FALSE)

fit <- f_dispensing_models(
  observed$vf, dosing_schedule_df,
  model_k0 = "zero-inflated poisson",
  model_t0 = "log-logistic",
  model_t1 = "least squares",
  model_ki = "zero-inflated poisson",
  model_ti = "least squares",
  model_di = "linear mixed-effects model",
  nreps = 200, showplot = FALSE)

trialsdt = df2$trialsdt[1]
cutoffdt = df2$cutoffdt[1]
t0 = as.numeric(cutoffdt - trialsdt + 1)
nyears = 3
t1 = t0 + nyears*365

vf_ongoing_new <- f_ongoing_new(
  pred$event_pred$newEvents,
  observed$kit_description_df,
  observed$treatment_by_drug_df,
  observed$vf)

vf_ongoing <- vf_ongoing_new$vf_ongoing
vf_new <- vf_ongoing_new$vf_new

vf_ongoing1 <- vf_ongoing \%>\%
  group_by(draw, usubjid) \%>\%
  slice(n()) \%>\%
  mutate(V = day - 1,
         C = as.numeric(t0 - arrivalTime),
         D = pmin(time - 1, t1 - arrivalTime)) \%>\%
  select(-c("kit", "kit_name", "day", "dose"))

### new patients and ongoing patients with no dosing records ###
vf_new1 <- vf_new \%>\%
  group_by(draw, usubjid) \%>\%
  slice(n()) \%>\%
  mutate(V = 0,
         C = as.numeric(t0 - arrivalTime),
         D = pmin(time - 1, t1 - arrivalTime)) \%>\%
  select(-c("kit", "kit_name"))

dosing_subject_new1 <- f_dose_draw_t_1(
  1, fit$k0_fit, fit$t0_fit, fit$t1_fit,
  fit$ki_fit, fit$ti_fit, vf_ongoing1, vf_new1)

head(dosing_subject_new1)
}

}
\seealso{
\code{\link{f_fit_t0}}, \code{\link{f_fit_ki}},
\code{\link{f_fit_ti}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
