% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_bias_binary.R
\name{EPsProg_bias_binary}
\alias{EPsProg_bias_binary}
\alias{EPsProg_binary_L}
\alias{EPsProg_binary_L2}
\alias{EPsProg_binary_R}
\alias{EPsProg_binary_R2}
\title{Expected probability of a successful program for bias adjustment programs with binary distributed outcomes}
\usage{
EPsProg_binary_L(
  RRgo,
  n2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  p0,
  w,
  p11,
  p12,
  in1,
  in2,
  fixed
)

EPsProg_binary_L2(
  RRgo,
  n2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  p0,
  w,
  p11,
  p12,
  in1,
  in2,
  fixed
)

EPsProg_binary_R(
  RRgo,
  n2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  p0,
  w,
  p11,
  p12,
  in1,
  in2,
  fixed
)

EPsProg_binary_R2(
  RRgo,
  n2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  p0,
  w,
  p11,
  p12,
  in1,
  in2,
  fixed
)
}
\arguments{
\item{RRgo}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be even number}

\item{Adj}{adjustment parameter}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{step1}{lower boundary for effect size}

\item{step2}{upper boundary for effect size}

\item{p0}{assumed true rate of control group}

\item{w}{weight for mixture prior distribution}

\item{p11}{assumed true rate of treatment group}

\item{p12}{assumed true rate of treatment group}

\item{in1}{amount of information for \code{p11} in terms of sample size}

\item{in2}{amount of information for \code{p12} in terms of sample size}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{p11} is used as fixed effect}
}
\value{
The output of the functions \code{EPsProg_binary_L()}, \code{EPsProg_binary_L2()}, \code{EPsProg_binary_R()} and \code{EPsProg_binary_R2()} is the expected probability of a successful program.
}
\description{
To discount for overoptimistic results in phase II when calculating the optimal sample size in phase III,
it is necessary to use the following functions, which each describe a specific case:
\itemize{
\item \code{EPsProg_binary_L()}: calculates the expected probability of a successful for an additive adjustment factor (i.e. adjust the lower bound of the one-sided confidence interval),
however the go-decision is not affected by the bias adjustment
\item \code{EPsProg_binary_L2()}: calculates the expected probability of a successful for an additive adjustment factor (i.e. adjust the lower bound of the one-sided confidence interval)
when the go-decision is also affected by the bias adjustment
\item \code{EPsProg_binary_R()}: calculates the expected probability of a successful for a multiplicative adjustment factor (i.e. use estimate with a retention factor),
however the go-decision is not affected by the bias adjustment
\item \code{EPsProg_binary_R2()}: calculates the expected probability of a successful for a multiplicative adjustment factor (i.e. use estimate with a retention factor)
when the go-decision is also affected by the bias adjustment
}
}
\examples{
res <- EPsProg_binary_L(RRgo = 0.8, n2 = 50, Adj = 0, 
                                 alpha = 0.025, beta = 0.1, 
                                 step1 = 1, step2 = 0.95, p0 = 0.6,  w = 0.3,
                                 p11 =  0.3, p12 = 0.5, in1 = 300, in2 = 600, 
                                 fixed = FALSE)
          res <- EPsProg_binary_L2(RRgo = 0.8, n2 = 50, Adj = 0, 
                                 alpha = 0.025, beta = 0.1, 
                                 step1 = 1, step2 = 0.95, p0 = 0.6,  w = 0.3,
                                 p11 =  0.3, p12 = 0.5, in1 = 300, in2 = 600, 
                                 fixed = FALSE)
          res <- EPsProg_binary_R(RRgo = 0.8, n2 = 50, Adj = 1, 
                                 alpha = 0.025, beta = 0.1, 
                                 step1 = 1, step2 = 0.95, p0 = 0.6,  w = 0.3,
                                 p11 =  0.3, p12 = 0.5, in1 = 300, in2 = 600, 
                                 fixed = FALSE)
          res <- EPsProg_binary_R2(RRgo = 0.8, n2 = 50, Adj = 1, 
                                 alpha = 0.025, beta = 0.1, 
                                 step1 = 1, step2 = 0.95, p0 = 0.6,  w = 0.3,
                                 p11 =  0.3, p12 = 0.5, in1 = 300, in2 = 600, 
                                 fixed = FALSE)
}
\keyword{internal}
