% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurv_plot.R
\name{ggplot_surv}
\alias{ggplot_surv}
\title{Survival probability plot}
\usage{
ggplot_surv(model1, model2, data1, data2, n_trans, id)
}
\arguments{
\item{model1}{coxPH fitted model object (before SPSM)}

\item{model2}{coxPH fitted model object (after SPSM)}

\item{data1}{multistate data used in model1}

\item{data2}{multistate data used in model2}

\item{n_trans}{number of transition}

\item{id}{particular id from the dataset}
}
\value{
plot for survival curve of a particular id obtained from both the model
}
\description{
it gives plot with fitted survival curve obtained from two different coxPH model fitted before and after SPSM
}
\examples{
\donttest{
##
library(mstate)
data(EBMTdata)
data(EBMTupdate)
tmat<-transMat(x=list(c(2,3),c(3),c()),names=c("Tx","Rec","Death"))
covs<-c("dissub","age","drmatch","tcd","prtime","x1","x2","x3","x4")
msbmt<-msprep(time=c(NA,"prtime","rfstime"),status=c(NA,"prstat","rfsstat"),
             data=EBMTdata,trans=tmat,keep=covs)
msbmt1<-msprep(time=c(NA,"prtime","rfstime"),status=c(NA,"prstat","rfsstat"),
              data=EBMTupdate,trans=tmat,keep=covs)
msph3<-coxph(Surv(time,status)~dissub+age+drmatch+tcd+
             frailty(id,distribution='gamma'),data=msbmt[msbmt$trans==3,])
msph33<-coxph(Surv(Tstart,Tstop,status)~dissub+age +drmatch+ tcd+
              frailty(id,distribution='gamma'),data=msbmt1[msbmt1$trans==3,])
ggplot_surv(model1=msph3,model2=msph33,data1=msbmt,
           data2=msbmt1,n_trans=3,id=1)
#####
# plot1<-ggplot_surv(model1=msph3,model2=msph33,data1=msbmt,data2=msbmt1,
# ggsave("plot1.jpg",path="C:/Users/.....")
#####
##
}
}
\seealso{
\link{dscore}, \link{simfdata}, \link{cphGM}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
