% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleBTF_reg}
\alias{sampleBTF_reg}
\title{Sampler for first or second order random walk (RW) Gaussian dynamic linear model (DLM)}
\usage{
sampleBTF_reg(y, X, obs_sigma_t2, evol_sigma_t2, XtX, D = 1, chol0 = NULL)
}
\arguments{
\item{y}{the \code{T x 1} vector of time series observations}

\item{X}{the \code{T x p} matrix of time series predictors}

\item{obs_sigma_t2}{the \code{T x 1} vector of observation error variances}

\item{evol_sigma_t2}{the \code{T x p} matrix of evolution error variances}

\item{XtX}{the \code{Tp x Tp} matrix of X'X (one-time cost; see ?build_XtX)}

\item{D}{the degree of differencing (one or two)}

\item{chol0}{(optional) the \code{m x m} matrix of initial Cholesky factorization;
if NULL, use the \code{Matrix} package for sampling, otherwise use the \code{spam} package}
}
\value{
\code{T x p} matrix of simulated dynamic regression coefficients \code{beta}
}
\description{
Compute one draw of the \code{T x p} state variable \code{beta} in a DLM using back-band substitution methods.
This model is equivalent to the Bayesian trend filtering (BTF) model applied to \code{p}
dynamic regression coefficients corresponding to the design matrix \code{X},
assuming appropriate (shrinkage/sparsity) priors for the evolution errors.
}
\note{
Missing entries (NAs) are not permitted in \code{y}. Imputation schemes are available.
}
