% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_calculus.R
\name{discrete_integ}
\alias{discrete_integ}
\title{Discrete integration}
\usage{
discrete_integ(f, k, xd, x)
}
\arguments{
\item{f}{Function, or vector of function evaluations at \code{c(xd, x)}, the
design points \code{xd} adjoined with the query point(s) \code{x}.}

\item{k}{Order for the discrete integral calculation. Must be >= 0.}

\item{xd}{Design points. Must be sorted in increasing order, and have length
at least \code{k+1}.}

\item{x}{Query point(s).}
}
\value{
Discrete integral of \code{f} of order \code{k}, with respect to design points
\code{xd}, evaluated at the query point(s) \code{x}.
}
\description{
Computes the discrete integral of a function (or vector of function
evaluations) of a given order, with respect to given design points, and
evaluated at a given query point.
}
\details{
The discrete integral operator of order \eqn{k}, with respect to
design points \eqn{x_1 < \ldots < x_n}, is denoted \eqn{S^k_n}. It is the
inverse operator to the discrete derivative operator \eqn{\Delta^k_n}, so
that:
\deqn{
  S^k_n \Delta^k_n = \Delta^k_n S^k_n = \mathrm{Id},
  } where
\eqn{\mathrm{Id}} denotes the identity operator. It can also be represented
in a more explicit form, as follows. Acting on a function \eqn{f} of order
\eqn{k}, and evaluated at a query point \eqn{x}, it yields:
\deqn{
  (S^k_n f)(x) =
  \begin{cases}
  \displaystyle
  \sum_{j=1}^k h^{k-1}_j(x) \cdot f(x_j) +
  \sum_{j=k+1}^i h^{k-1}_j(x) \cdot \frac{x_j-x_{j-k}}{k} \cdot f(x_j)
  + h^{k-1}_{i+1}(x) \cdot \frac{x-x_{i-k+1}}{k} \cdot f(x) & \\
  & \hspace{-75pt} \text{if $x \in (x_i,x_{i+1}]$, $i \geq k$} \\
  \displaystyle
  \sum_{j=1}^i h^{k-1}_j(x) \cdot f(x_j) \,+\, h^{k-1}_{i+1}(x) \cdot f(x)
  & \hspace{-75pt} \text{if $x \in (x_i,x_{i+1}]$, $i <  k$} \\
  f(x) & \hspace{-75pt} \text{if $x \leq x_1$},
  \end{cases}
  }
where \eqn{h^{k-1}_1, \ldots, h^{k-1}_n} denote the falling factorial basis
functions of degree \eqn{k-1}, with knots in \eqn{x_{k:(n-1)}}. The help
file for \code{\link[=h_mat]{h_mat()}} gives a definition of the falling factorial basis. It
can be seen (due to the one-sided support of the falling factorial basis
functions) that discrete integration at \eqn{x = x_i}, \eqn{i = 1,\ldots,n}
is equivalent to multiplication by a weighted version of the falling
factorial basis matrix. For more details, including an alternative
recursive representation for discrete integration (that elucidates its
relationship to discrete differentiation), see Section 3.2 of Tibshirani
(2020).

\strong{Note:} for calculating discrete integrals at the design points themselves,
which could be achieved by taking \code{x = xd} in the current function, one
should instead use \code{\link[=h_mat_mult]{h_mat_mult()}} with \code{di_weighting = TRUE}, as this will
be \strong{much} more efficient (quadratic-time versus linear-time).
}
\examples{
xd = 1:10 / 10
discrete_integ(function(x) 1, 1, xd, xd)
}
\references{
Tibshirani (2020), "Divided differences, falling factorials, and
discrete splines: Another look at trend filtering and related problems",
Section 3.2.
}
\seealso{
\code{\link[=h_mat_mult]{h_mat_mult()}} for multiplication by the falling factorial basis
matrix, giving a weighted analog of discrete integration at the design
points.
}
