% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tern.R
\name{as_dtlg_table}
\alias{as_dtlg_table}
\title{Convert a TableTree to a dtlg table}
\usage{
as_dtlg_table(tt, .label_col = "stats")
}
\arguments{
\item{tt}{A TableTree object. Typically obtained with \code{\link[=tern_summary_table]{tern_summary_table()}}.}

\item{.label_col}{Label for stats' column.}
}
\value{
A data.table.
}
\description{
\code{\link[=as_dtlg_table]{as_dtlg_table()}} reformats a TableTree object into a format close to that
of dtlg's \code{data.table}.
}
\examples{
vars <- c('AGE', 'RACE', 'ETHNIC', 'BMRKR1')
var_labels <- c("Age (yr)", "Race", "Ethnicity", "Continuous Level Biomarker 1")

# Summary statistics table split by ARM with custom labels.
(tt <- tern_summary_table(
  adsl,
  target = vars,
  treat = 'ARM',
  target_name = var_labels
))

# Format as a dtlg table
as_dtlg_table(tt)

}
