% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dualScale}
\alias{plot.dualScale}
\title{Plot of Dual Scale analysis}
\usage{
\method{plot}{dualScale}(x, dim1 = 1, dim2 = 2, type = c("Asy1", "Asy2", "Sub", "Ite"), ...)
}
\arguments{
\item{x}{A Dual Scale object}

\item{dim1}{Component for the horizontal axis. Default dimension 1}

\item{dim2}{Component for the vertical axis. Default dimension 2}

\item{type}{Graph type
\describe{
\item{Asy1}{Assymetric graph for projected options versus normed subjects
(default)}
\item{Asy2}{Assymetric graph for normed options versus projected subjects}
\item{Sub}{Only subjects graph}
\item{Ite}{Only items graph}
}}

\item{...}{Arguments to be passed to methods}
}
\value{
A plot of the available information from the object
}
\description{
Plot of Dual Scale analysis
}
\examples{
plot(ds_cf(curricula))
plot(ds_mc(singaporean))
plot(ds_mcf(singaporean, crit = 1))
plot(ds_pc(christmas))
plot(ds_ro(goverment))
}
\seealso{
\code{\link[=plot]{plot()}},\code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2()}}
}
