% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynafluxr.R
\name{fdyn}
\alias{fdyn}
\title{Retrieve flux dynamics from metabolic kinetics}
\usage{
fdyn(
  mf,
  stofull,
  nsp = 4L,
  nki = 5L,
  lieq = NULL,
  monotone = 0,
  dls = FALSE,
  atomlen = NULL,
  npi = 300L,
  wsd = FALSE,
  nmsf = character(0L),
  sderr = NULL,
  tol = 1e-10,
  regular_grid = TRUE
)
}
\arguments{
\item{mf}{Data-frame or matrix, specie kinetic measurements.
Columns must be named with specie names and 'Time'.}

\item{stofull}{Full stoichiometric matrix, \code{stofull[i,j]} means reaction 'j' produces
specie 'i' with coeficient 'stofull[i,j]'. If \code{stofull[i,j] < 0},
the specie 'i' is consumed. Columns must be named with reaction names.
Rows must be names with the species. "Full" in the name means that matrix includes
even NA species.}

\item{nsp}{Integer, polynomial order of B-spline to use for species
(default 4)}

\item{nki}{Integer, number of internal knots for B-splines
(default 5)}

\item{lieq}{List, equality constraints on species
(default NULL, i.e. no equality constraint)}

\item{monotone}{Numeric scalar or vector, 1=species are
monotonically increasing;
-1=monotonically decreasing; 0=no constraint. If vector, each value
constraints (or not) a corresponding data column in mf ('Time'
column is excluded
from counting)
(default 0, i.e. no monotonicity constraint)}

\item{dls}{Logical scalar, if TRUE, indicates that differential least squares
should be resolved instead of integral least squares.
(default FALSE, i.e. ILS will be used)}

\item{atomlen}{Numerical named vector, indicates what is label length
of a given specie used a vector item name. If provided, results
will contain \code{lsp} and \code{ilsp} fields which
are a B-spline function representing atom balance over msp and isp splines.
(default NULL, i.e. no atom balance will be provided)}

\item{npi}{Integer scalar, indicates a number of plot intervals to produce smooth plots.
(default 300)}

\item{wsd}{Logical scalar, if TRUE, indicates that differential least squares
should be resolved with residuals weighted by a factor of covariance matrix.
(default FALSE, i.e. no weighting is used)}

\item{nmsf}{Character vector, list of species for which scaling factor maust be estimated for --dls.}

\item{sderr}{Numeric vector, use this SD of measured metabolites instead of automatically estimated. The name of each vector component is metabolite name, tha value is SD vale, e.g. \code{c(GLC=0.1)} (default NULL, i.e. SD are automatically estimated).}

\item{tol}{Double scalar, tolerance for detecting singular matrices and solving linear systems}

\item{regular_grid}{Logical scalar, use regular knot grid (default: TRUE)}
}
\value{
List with following components:
\describe{
  \item{mf:}{ specie data frame used for fitting}
  \item{tp:}{ vector of time points for used measurements}
  \item{tpp:}{ vector of time points for plot (fine time resolution)}
  \item{sto:}{ stoichiometric matrix used for fitting}
  \item{stofull:}{ stoichiometric matrix before a possible NA elimination}
  \item{stoinv:}{ pseudo-inverse of sto}
  \item{msp:}{ measured specie spline function}
  \item{vsp:}{ estimated rates spline function}
  \item{fsp:}{ estimated total flux (S*v) spline function}
  \item{dsp:}{ first derivative of measured spline function}
  \item{isp:}{ integrated specie spline function}
  \item{asp:}{ atom balance over msp spline function}
  \item{iasp:}{ atom balance over isp spline function}
  \item{vsp:}{ flux spline function}
  \item{dsp:}{ measured specie first derivative spline function}
  \item{rsp:}{ residual \code{dM/dt - S\%*\%v} spline function}
  \item{risp:}{ integral residual \code{M - \\u222bS\%*\%v dt} spline function}
  \item{sdrate:}{ matrix of SD values for flux B-spline coefficients, of size (\code{ncoef x nrate})}
  \item{chi2tab:}{ data-frame with chi2-test results}
  \item{sf:}{ named scale factor vector}
  \item{internal_knot_ref:}{ number of internal knots used for estimation of var_ref}
}
}
\description{
Retrieve flux dynamics from metabolic kinetics
}
\details{
Each item in \code{lieq} corresponds to a specie and is a
  2 column matrix (Time, Value). Each
  row of this matrix indicates what 'Value' must take corresponding
  specie at what 'Time'. Typically, it can be used to impose
  starting values at Time=0 for some species.\cr
  All specie fits are constraint to have values >= 0.
}
