% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleLSV.R
\name{sampleLSV}
\alias{sampleLSV}
\title{Create Subsample of a Simulated Linear Sweep Voltammogram}
\usage{
sampleLSV(filename, data.reduction = 1)
}
\arguments{
\item{filename}{The filename that contains the result of a simulated linear sweep voltammetry experiment (created using the \code{lsvSim} function).}

\item{data.reduction}{A value that gives the percentage of the original data to keep, which then is spaced evenly across the full data set.}
}
\value{
Returns a list with the following components \item{expt}{type of experiment; LSV for a linear sweep voltammetry experiment} \item{file_type}{value that indicates whether the output includes all data (full) or a subset of data (reduced); defaults to reduced} \item{current}{vector giving the current as a function of time} \item{potential}{vector giving the potential as a function of time}
}
\description{
Used to create a reduced data file of potentials and currents for a linear sweep voltammogram. When passed to plotLSV, the resulting plot shows the data as discrete points instead of as a line.
}
\examples{
ex_lsv = simulateLSV(e.start = 0.25, e.end = -0.25, e.form = 0,
  stir.rate = "fast", x.units = 100, t.units = 1000)
ex_lsvsample = sampleLSV(ex_lsv, data.reduction = 5)
str(ex_lsvsample)
}
