% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/molarityconversions.R
\name{ng2nM}
\alias{ng2nM}
\alias{nM2ng}
\title{functions to translate mass into molarity and vice versa, given we are talking about double stranded DNA
it requires two inputs, the mass (or molarity) and the length of the DNA fragment
It works with the two most common concentrations used in Molecular Ecology labs
 ng/\eqn{\mu}l for mass
 nM for molarity}
\usage{
ng2nM(ng, length_amplicon)

nM2ng(nM, length_amplicon)
}
\arguments{
\item{ng}{Numeric. the concentration in ng per \eqn{\mu}L}

\item{length_amplicon}{Integer. The length of the DNA fragment in base pairs.}

\item{nM}{Numeric. The concentration in nmoles per litre}
}
\value{
Numeric. The equivalent concentration in nmoles per litre

Numeric. The equivalent concentration in ng per \eqn{\mu}L
}
\description{
functions to translate mass into molarity and vice versa, given we are talking about double stranded DNA
it requires two inputs, the mass (or molarity) and the length of the DNA fragment
It works with the two most common concentrations used in Molecular Ecology labs
 ng/\eqn{\mu}l for mass
 nM for molarity
}
\examples{

data("molarity.data")
ng2nM(ng=molarity.data$mass, length_amplicon = molarity.data$Amp_len)


data("molarity.data")
nM2ng(nM=molarity.data$Molarity, length_amplicon = molarity.data$Amp_len)


}
