% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTMA_import.R
\name{exact.kde}
\alias{exact.kde}
\title{Exact kernel density estimation}
\usage{
exact.kde(x, bw, output.domain = x, na.rm = FALSE)
}
\arguments{
\item{x}{A numeric vector of values}

\item{bw}{The bandwidth to use - either a single value, or a vector of
values the same length as \code{x} if using adaptive bandwidth estimation
(with each value giving the bandwidth at the corresponding data point).}

\item{output.domain}{The domain of values over which to estimate the
density. Defaults to \code{x}. To use the same domain of \code{x} values
as \R's \code{density}, set to \code{NULL}.}

\item{na.rm}{Remove missing values if \code{TRUE}}
}
\value{
The exact kernel density estimate as a \code{density} object,
  compatible with \R's \code{density} function.
}
\description{
Calculates KDE for a set of points exactly, rather than an approximation as
per the density() core function.
}
\details{
Only tractable for around 10,000 data points or less - otherwise consider
using the density() core function for a close approximation.

The density() core function approximation is normally a very good approximation, but
some small values close to zero may become zero rather than just very small.
This makes it less suitable for mutual information estimation.
}
\author{
Alexander Lyulph Robert Lubbock, Ian Overton
}
