% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel3D.R
\name{parpbsapply}
\alias{parpbsapply}
\title{Parallel sapply with progressbar}
\usage{
parpbsapply(
  X,
  FUN,
  packages = NULL,
  export = NULL,
  envir = environment(),
  nNodes = parallel::detectCores() - 1
)
}
\arguments{
\item{X}{a vector (atomic or list) or an expression object. Other objects (including classed objects) will be coerced by base::as.list.}

\item{FUN}{function, the function to be applied to each element of X}

\item{packages}{character vector, Only relevant for Windows: the packages needed in the function provided, eg. c("MASS", "data.table")}

\item{export}{character vector, Only relevant for Windows: the varibales needed in the function provided, eg. c("df", "vec")}

\item{envir}{environment, Only relevant for Windows: Environment from which the variables should be exported from}

\item{nNodes}{numeric, Number of processes to start (unix: best to fit with the available Cores)}
}
\value{
A vector with the results.
}
\description{
Function detects the operating system and chooses the approximate kind of process for parallelizing the task:
Windows: PSOCKCluster, Unix: Forking.
}
\examples{
square <- function(x) {
  x * x
}
s <- parpbsapply(X = 1:1000, FUN = square, export = c("square"), nNodes = 2)
}
