% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PTxyz.R
\name{PTxyz}
\alias{PTxyz}
\title{ProtectTable with output ready for SuppressDec in package RegSDC}
\usage{
PTxyz(data, dimVar, freqVar, ...)
}
\arguments{
\item{data}{data frame}

\item{dimVar}{The main dimensional variables and additional aggregating variables (name or number).}

\item{freqVar}{Variable(s) holding counts (name or number).}

\item{...}{Further parameters sent to \code{\link{ProtectTable}}}
}
\value{
List of three matrices ready as input to \code{SuppressDec}
\item{x}{Sparse dummy matrix where the dimensions match z and y.}
\item{z}{Frequencies to be published with suppressed as NA.}
\item{y}{Inner cell frequencies.}
}
\description{
Assuming correct suppression, suppressed values become decimal numbers (not whole numbers) instead of missing.
}
\details{
Within this r package this function will be used for testing
}
\examples{
\dontrun{

# Same examples as in ProtectTable 
a1 <- PTxyz(EasyData("z1"), c("region","hovedint") ,"ant")
a2 <- PTxyz(EasyData("z2"), c(1,3,4),5) 
 
if (require(RegSDC)) { # RegSDCdata and SuppressDec
  # Same data as in RegSDCdata examples (and in paper)
  data7 <- RegSDCdata("sec7data")
  data7 <- data7[!is.na(data7$y), 1:3]
  data7

  # Generate x, y, z similar to xAll, y, zAllSupp in RegSDCdata examples 
  # But different suppressed cells and z ordered differently
  a <- PTxyz(data7, 1:2, 3, maxN = 3, method = "HITAS")
  a

  # Suppressed inner cells as decimal numbers
  yDec <- SuppressDec(a$x, a$z, a$y, rmse = 1)
  yDec

  # All cells as decimal numbers
  cbind(a$z, t(a$x) \%*\% cbind(a$y, yDec))

  # As ProtectTable example
  z1 <- EasyData("z1")
  a <- PTxyz(z1, c("region", "hovedint"), "ant")

  # Inner cells as decimal numbers. 3 replicates.
  yDec <- SuppressDec(a$x, a$z, a$y, nRep = 3)
  yDec

  # All cells with 3 replicates.
  cbind(a$z, t(a$x) \%*\% cbind(a$y, yDec))
}

if (require(RegSDC)) {
  # An example involving two linked tables.  
  # It is demonstrated that the SIMPLEHEURISTIC approach to suppression is not safe.  
  # That is, perfect fit (whole numbers) for some suppressed cells.
  a <- PTxyz(EasyData("z3"), 1:5, 7, method = "SIMPLEHEURISTIC", protectZeros= FALSE)
  cbind(a$z, t(a$x) \%*\% cbind(a$y, SuppressDec(a$x, a$z, rmse=pi/3, nRep=3)))[which(is.na(a$z)), ]
}}
}
\author{
Øyvind Langsrud
}
