% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_table.R
\name{cens_parse_tables}
\alias{cens_parse_tables}
\title{Attempt to Parse Tables from a Census API}
\usage{
cens_parse_tables(api, year)
}
\arguments{
\item{api}{A Census API programmatic name such as \code{"acs/acs5"}.}

\item{year}{The year for the data}
}
\value{
A list of \code{cens_table} objects, which are just lists with four elements:
\itemize{
\item \code{concept}, a human-readable name
\item \code{tables}, the constituent table codes
\item \code{surveys}, the supported surveys
\item \code{dims}, the parsed names of the dimensions of the tables
\item \code{vars}, a \code{tibble} with all of the parsed variable values
}
}
\description{
Uses the same parsing code as that which generates \link{tables_sf1} and \link{tables_acs}
See \url{https://www.census.gov/data/developers/data-sets.html} for a list of
APIs and corresponding years, or use \code{\link[censusapi:listCensusApis]{censusapi::listCensusApis()}}.
}
\examples{
\dontrun{
cens_parse_tables("dec/pl", 2020)
}

}
