% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{package}
\alias{package}
\title{package()}
\usage{
package(name, install = utils::install.packages, ..., load_type = "attach")
}
\arguments{
\item{name}{the name of a package, or, if the package is on Github, the
username and repo of the package, ex. Rdatatable/data.table, where 
Rdatatable is the GitHub username, and data.table is the repo name. The 
same process works with Bitbucket, except \code{$} is used instead of 
\code{/} to separate the username and repo.}

\item{install}{(optional) a function used to install a package.}

\item{...}{(optional) additional arguments to the \code{install} function.
Another way of supplying additonal parameters to \code{install} is to use
the \code{purrr::partial} function.}

\item{load_type}{(default is "attach") should the package be loaded, or 
attached? See http://r-pkgs.had.co.nz/namespace.html to learn more.}
}
\description{
A package object that contains at minimum the name of a package. If the 
package exists on CRAN, the name of the package is used to install that
package from CRAN. A forward slash may be used in the package name to 
indicate a GitHub username and repo that a package is located in. A dollar
sign may be used in the package name to indicate a Bitbucket username and 
repo that a package is located in.
}
\details{
If a package is not inteded to be installed from CRAN, Github (public), or 
Bitbucket (public) you may optionally supply a function to the 
\code{install} argument that installs the package, with additional arguments
to the function supplied via the \code{...} argument.
}
\examples{
\dontrun{
this_package <- package("dplyr")
github_package <- package("Rdatatable/data.table")
that_package <- package("jakePackage", devtools::install_bitbucket, 
repo = "repo", username = "user", password = "password")
}
}

