% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_fns.R
\name{ebnm_point_normal}
\alias{ebnm_point_normal}
\title{Solve the EBNM problem using point-normal priors}
\usage{
ebnm_point_normal(
  x,
  s = 1,
  mode = 0,
  scale = "estimate",
  g_init = NULL,
  fix_g = FALSE,
  output = ebnm_output_default(),
  optmethod = NULL,
  control = NULL
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A vector of standard errors (or a scalar if all are equal).
Standard errors may not be exactly zero, and missing standard errors are
not allowed.}

\item{mode}{A scalar specifying the mode of the prior \eqn{g} or
\code{"estimate"} if the mode is to be estimated from the data.}

\item{scale}{A scalar specifying the standard deviation of the normal
component or \code{"estimate"} if the standard deviation is to be estimated
from the data.}

\item{g_init}{The prior distribution \eqn{g}. Usually this is left
unspecified (\code{NULL}) and estimated from the data. However, it can be
used in conjuction with \code{fix_g = TRUE} to fix the prior (useful, for
example, to do computations with the "true" \eqn{g} in simulations). If
\code{g_init} is specified but \code{fix_g = FALSE}, \code{g_init}
specifies the initial value of \eqn{g} used during optimization. When
supplied, \code{g_init} should be an object of class
\code{\link[ashr]{normalmix}} or an \code{ebnm} object in which the fitted
prior is an object of class \code{normalmix}.}

\item{fix_g}{If \code{TRUE}, fix the prior \eqn{g} at \code{g_init} instead
of estimating it.}

\item{output}{A character vector indicating which values are to be returned.
Function \code{ebnm_output_default()} provides the default return values, while
\code{ebnm_output_all()} lists all possible return values. See \strong{Value}
below.}

\item{optmethod}{A string specifying which optimization function is to be
used. Options include \code{"nlm"} (which calls \code{\link[stats]{nlm}}),
\code{"lbfgsb"} (which calls \code{\link[stats]{optim}}
with \code{method = "L-BFGS-B"}), and \code{"trust"} (which
calls into the \code{\link[trust]{trust}} package).
Other options are \code{"nohess_nlm"},
\code{"nograd_nlm"}, and \code{"nograd_lbfgsb"}, which use numerical
approximations rather than exact expressions for the Hessian; both of the
\code{"nograd"} functions use numerical approximations for the gradient as
well. The default option is \code{"nohess_nlm"}.}

\item{control}{A list of control parameters to be passed to the
optimization function specified by parameter \code{optmethod}.}
}
\value{
An \code{ebnm} object. Depending on the argument to \code{output}, the
  object is a list containing elements:
    \describe{
      \item{\code{data}}{A data frame containing the observations \code{x}
        and standard errors \code{s}.}
      \item{\code{posterior}}{A data frame of summary results (posterior
        means, standard deviations, second moments, and local false sign
        rates).}
      \item{\code{fitted_g}}{The fitted prior \eqn{\hat{g}}.}
      \item{\code{log_likelihood}}{The optimal log likelihood attained,
        \eqn{L(\hat{g})}.}
      \item{\code{posterior_sampler}}{A function that can be used to
        produce samples from the posterior. The sampler takes a single
        parameter \code{nsamp}, the number of posterior samples to return per
        observation.}
     }
   S3 methods \code{coef}, \code{confint}, \code{fitted}, \code{logLik},
   \code{nobs}, \code{plot}, \code{predict}, \code{print}, \code{quantile},
   \code{residuals}, \code{simulate}, \code{summary}, and \code{vcov}
   have been implemented for \code{ebnm} objects. For details, see the
   respective help pages, linked below under \strong{See Also}.
}
\description{
Solves the empirical Bayes normal means (EBNM) problem using the family of
  point-normal priors (the family of mixtures where one component is a point
  mass at \eqn{\mu} and the other is a normal distribution centered at
  \eqn{\mu}). Identical to function \code{\link{ebnm}} with argument
  \code{prior_family = "point_normal"}. For details about the model, see
  \code{\link{ebnm}}.
}
\seealso{
See \code{\link{ebnm}} for examples of usage and model details.

  Available S3 methods include \code{\link{coef.ebnm}},
  \code{\link{confint.ebnm}},
  \code{\link{fitted.ebnm}}, \code{\link{logLik.ebnm}},
  \code{\link{nobs.ebnm}}, \code{\link{plot.ebnm}},
  \code{\link{predict.ebnm}}, \code{\link{print.ebnm}},
  \code{\link{print.summary.ebnm}}, \code{\link{quantile.ebnm}},
  \code{\link{residuals.ebnm}}, \code{\link{simulate.ebnm}},
  \code{\link{summary.ebnm}}, and \code{\link{vcov.ebnm}}.
}
