% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{-- Introduction --}
\alias{-- Introduction --}
\title{echarty}
\description{
echarty
}
\details{
\subsection{Description}{

\strong{echarty} provides a lean interface between R and Javascript library
\href{https://echarts.apache.org/en/index.html}{ECharts}.
We encourage users to follow the original ECharts \href{https://echarts.apache.org/en/option.html}{API documentation} to construct
charts with echarty.
Main command \strong{ec.init} can set multiple native ECharts options to
build a chart.
The benefits - learn a very limited set of commands, and enjoy the
\strong{full functionality} of ECharts.
}

\subsection{Package Conventions}{

pipe-friendly - supports both \%>\% and |>
commands have three prefixes to help with auto-completion:
\itemize{
\item \strong{ec.} for general functions, like \emph{ec.init}
\item \strong{ecs.} for Shiny functions, like \emph{ecs.output}
\item \strong{ecr.} for rendering functions, like \emph{ecr.band}
}
}

\subsection{Events}{

Event handling in \strong{Shiny} is done through callbacks.\if{html}{\out{<br>}} See
considerable sample code in
\href{https://github.com/helgasoft/echarty/blob/main/demo/eshiny.R}{eshiny.R},
run as \code{demo(eshiny)}.\if{html}{\out{<br>}} There are three built-in event callbacks -
\emph{click}, \emph{mouseover}, \emph{mouseout}. All other ECharts
\href{https://echarts.apache.org/en/api.html#events}{events} could be
initialized through \code{ec.init(capture=...)}. \if{html}{\out{<br>}} For event handling in R
(without Shiny) use parameter \code{ec.init(on=...)} which expects JavaScript
handlers. Search for ‘event’ in \href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{code examples}.
}

\subsection{ECharts initialization parameters}{

Chart initialization is performed by the \emph{echarty::ec.init()}
command.\if{html}{\out{<br>}} Here is full list of \emph{ec.init} optional parameters:
\itemize{
\item \emph{ask, js, elementId, ctype, xtKey, dbg} are specific to \emph{echarty}\if{html}{\out{<br>}}
\item \emph{theme, iniOpts, on, off, capture, group} belong to the ECharts \href{https://echarts.apache.org/en/api.html#echartsInstance}{chart instance}
object.\if{html}{\out{<br>}}
\item \emph{connect, disconnect, registerMap, registerTheme, registerLocale,
registerCustomSeries} are commands of the global \href{https://echarts.apache.org/en/api.html#echarts}{ECharts object}.
}

There are R \href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{code examples}
for some of these parameters.
}

\subsection{R vs Javascript numbering}{

R language counting starts from 1.\if{html}{\out{<br>}} Javascript (JS) counting starts
from 0.\if{html}{\out{<br>}} \emph{ec.init} supports R-counting of indexes (ex. encode) and
dimension (ex. visualMap).\if{html}{\out{<br>}} All other contexts like \emph{ec.upd} or
\emph{ecs.proxy} require JS-counting of indexes and dimensions.
}

\subsection{Javascript built-in functions}{

To allow access to charts from JS.\if{html}{\out{<br>}} \strong{ec_chart(id)} - get the chart
object by id \if{html}{\out{<br>}} \strong{ec_option(id)} - get the chart’s option object by
id \if{html}{\out{<br>}} Parameter \emph{id} could be the internal JS variable \emph{echwid}, or
the value set through \emph{ec.init} parameter \emph{elementId}. See \href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{code examples}.
}

\subsection{Column-to-style binding with encode}{

ECharts \href{https://echarts.apache.org/en/option.html#series-bar.encode}{series encode}
enables binding axes and tooltip to data columns. Echarty enhances this
method for all \href{https://echarts.apache.org/en/option.html#series-bar.data}{series data}
parameters like itemStyle,labels,emphasis,etc. The bindings are set
through \code{series$encode$data}. For instance\if{html}{\out{<br>}}
\code{encode= list(data= list(value= c('xc','yc'), itemStyle= list(opacity= 'oc')))}\if{html}{\out{<br>}}
would match columns \emph{xc,yc,oc} to each item’s value and opacity. The
result is a new \code{series$data} added to the series. It permits to finely
customize chart elements directly from data.\if{html}{\out{<br>}} Echarty has also an
alternative tool, style-named columns with \code{ec.data(..nasep)}, but
\code{encode$data} offers more flexibility. It is not compatible with
\emph{timeline} however.
}

\subsection{Code examples}{

Here is the complete list of sample code \strong{locations}:
\itemize{
\item website
\href{https://helgasoft.github.io/echarty/articles/gallery.html}{gallery}
\item collection of \href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{code examples}
\item Shiny code is in
\href{https://github.com/helgasoft/echarty/blob/main/demo/eshiny.R}{eshiny.R},
run with \code{demo(eshiny)}
\item demos on \href{https://rpubs.com/echarty}{RPubs}
\item searchable \href{https://gist.github.com/helgasoft}{gists}
\item answers to \href{https://github.com/helgasoft/echarty/issues}{Github issues}
\item code in \href{https://github.com/helgasoft/echarty/tree/main/tests/testthat}{Github tests}
\item command examples, like in \emph{?ec.init}
}
}

\subsection{Global Options}{

Options are set with R command
\href{https://www.rdocumentation.org/packages/base/versions/3.6.2/topics/options}{options}.
Echarty uses the following options:
\itemize{
\item echarty.theme = name of theme file, without extension, from folder
\verb{/inst/themes}
\item echarty.font = font family name
\item echarty.urlTiles = tiles URL template for leaflet maps
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# set/get global options
options('echarty.theme'='jazz') # set
getOption('echarty.theme')      # get
#> [1] "jazz"
options('echarty.theme'=NULL)   # remove
}\if{html}{\out{</div>}}
}
}
