% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectoryConvergencePlot.R
\encoding{UTF-8}
\name{trajectoryConvergencePlot}
\alias{trajectoryConvergencePlot}
\title{Summary plot for trajectory convergence and divergence}
\usage{
trajectoryConvergencePlot(
  x,
  type = "pairwise.asymmetric",
  alpha.filter = NULL,
  traj.colors = "grey",
  traj.names = NULL,
  traj.names.colors = "black",
  ...,
  radius = 1,
  conv.color = "red",
  div.color = "blue",
  half.arrows.size = 1,
  tau.links.transp = 0.3,
  top = "between",
  pointy = FALSE,
  add = TRUE
)
}
\arguments{
\item{x}{An object of class \code{\link{trajectories}}. Alternatively, an object of class \code{\link{RTMA}}.}

\item{type}{A string indicating the convergence test to be displayed, either \code{"pairwise.asymmetric"}, \code{"pairwise.symmetric"} or \code{"both"} (see \code{\link{trajectoryConvergence}}). Disregarded if \code{inherits(x,"RTMA")}.}

\item{alpha.filter}{The minimum p-value for a link to be drawn (see \code{\link{trajectoryConvergence}}). Defaults to \code{NULL} (all links drawn). Disregarded if \code{inherits(x,"RTMA")} (the RTMA corrected alpha level is used instead).}

\item{traj.colors}{The colors for the trajectories (circles). Defaults to \code{"grey"}.}

\item{traj.names}{The names of trajectories. Defaults to the names provided in \code{x}.}

\item{traj.names.colors}{The color of the names of trajectories on the circles. Defaults to \code{"black"}.}

\item{...}{Additional parameters passed to \code{\link{polygon}} to personalize the circles representing trajectories.}

\item{radius}{The radius of the circles representing trajectories. Defaults to \code{1}.}

\item{conv.color}{The color used to mark convergent trajectories. Defaults to \code{"red"}.}

\item{div.color}{The color used to mark divergent trajectories. Defaults to \code{"blue"}.}

\item{half.arrows.size}{A multiplication coefficient for the size of the arrow heads when representing asymmetric tests results. Defaults to \code{1}.}

\item{tau.links.transp}{The transparency of the links representing the tau statistic of the Mann-Kendall test (see \code{\link{trajectoryConvergence}}).}

\item{top}{A string indicating if the top of the plotting area should contain a circle representing a trajectory (\code{"circle"}), or should be in between two circles (\code{"between"}). Defaults to \code{"between"}.}

\item{pointy}{Boolean. Should the circles representing trajectories be made pointy (i.e. pointing to the next trajectory)? Useful when trajectories have some order, as in the context of CETA to represent fixed date trajectories (see \code{\link{trajectoryCyclical}}).}

\item{add}{Passed to function \code{\link{trajectoryConvergence}}. Flag to indicate that constant values should be added (local transformation) to correct triplets of distance values that do not fulfill the triangle inequality. Disregarded if \code{inherits(x,"RTMA")}.}
}
\description{
Provides plots to represent trajectory convergence and divergence tests performed by the function \code{\link{trajectoryConvergence}} or to present the results of Relative Trajectory Movement Assessment (\code{\link{trajectoryRMA}}).
}
\details{
Function \code{trajectoryConvergencePlot} provides ways to visualize pairwise convergence and divergence between trajectories.
It has two modes of functioning:
\itemize{
\item{If \code{x} is of class \code{\link{trajectories}}, the function will display the results of convergence/divergence tests by calls to function \code{\link{trajectoryConvergence}}.}
\item{If \code{x} is of class \code{\link{RTMA}},the function will display the results of convergence/divergence tests and dynamic correspondence tests stored in the \code{\link{RTMA}} object supplied.}
}
In the plots, trajectories are represented by circles. The convergence or divergence between pairs of trajectories are represented by links. If convergence tests are symmetric, the links are simple. If the convergence tests are asymmetric, the links are displayed as half arrows pointing from the trajectory converging or diverging towards the trajectory being approached or diverged from.
The width and color hue of the links are proportional to the tau statistic of the Mann-Kendall test performed by the \code{\link{trajectoryConvergence}} function.
Function \code{trajectoryConvergencePlot} also offers the possibility to plot both tests at the same time.

If \code{x} is of class \code{\link{RTMA}}, \code{trajectoryConvergencePlot} will display both convergence tests as explained above, as well as cases of parallelism recognized in \code{\link{trajectoryRMA}}.
\code{Parallel} scenarios are indicated by two full parallel black lines linking two trajectories, while in case of \code{Antiparallel} scenarios one of the lines is dotted.

In addition, see function \code{\link{cycleShiftArrows}} for additional graphical elements to be displayed when conducting CETA.
}
\examples{
data("avoca")
avoca_D_man <- vegclust::vegdiststruct(avoca_strat, 
                                       method ="manhattan", 
                                       transform = function(x){log(x+1)})
years <- c(1971, 1974, 1978, 1983, 1987, 1993, 1999, 2004, 2009)
avoca_times <- years[avoca_surveys]
avoca_x <- defineTrajectories(d = avoca_D_man,  
                              sites = avoca_sites, 
                              times = avoca_times)

#Raw output with asymmetric convergence test (default)
trajectoryConvergencePlot(avoca_x)

#More refined output with both type of tests and only plotting significant 
#test results (p-value < 0.05)
trajectoryConvergencePlot(avoca_x,
                          type = "both",
                          alpha.filter = 0.05)

#Much more refined output with nicer colors, bigger half arrows, 
#personalized trajectory names, controlling the size of circles representing 
#trajectories and border customization.
trajectoryConvergencePlot(avoca_x,type = "both",alpha.filter = 0.05,
                          half.arrows.size = 1.5, 
                          conv.color = "orangered",
                          div.color = "dodgerblue",
                          radius = 1.2, 
                          traj.colors = "black",border = "white",lwd = 2,
                          traj.names = LETTERS[1:8],traj.names.colors = "white")
#RTMA version.
avoca_RTMA <- trajectoryRMA(avoca_x)
trajectoryConvergencePlot(avoca_RTMA,
                          half.arrows.size = 1.5, 
                          conv.color = "orangered",
                          div.color = "dodgerblue",
                          radius = 1.2, 
                          traj.colors = "black",border = "white",lwd = 2,
                          traj.names = LETTERS[1:8],traj.names.colors = "white")
                          
}
\references{
Djeghri et al. (in preparation) Uncovering the relative movements of ecological trajectories.
}
\seealso{
\code{\link{trajectoryConvergence}},\code{\link{trajectoryRMA}}, \code{\link{cycleShiftArrows}}
}
\author{
Nicolas Djeghri, UBO

Miquel De \enc{Cáceres}{Caceres}, CREAF
}
