% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{with_variables}
\alias{with_variables}
\title{A helper function to set variables that the record is dependent on.}
\usage{
with_variables(
  ...,
  .missing = FALSE,
  .interaction = random_true_false(),
  .discrete = FALSE,
  .linear = random_true_false(),
  .error_dist = NULL
)
}
\arguments{
\item{...}{A series of factors in which the record is explicitly dependent upon (tidyselect campatible).}

\item{.missing}{A logical value indicating whether there should be some
missing values. Default is FALSE. The missing values are introduced at random.
It can also be numeric of between 0 and 1 giving the proportion of missing values.}

\item{.interaction}{Whether there should be treatment interaction effects.}

\item{.discrete}{Whether to make the response value discrete or not.}

\item{.linear}{Whether to include non-linear term or not. The value is always additive.}

\item{.error_dist}{The random distribution to use for numerical values
(either "normal", "uniform", "exponential", "gamma", "beta", "cauchy", "chisq", "f", "t", "poisson", "weibull").
The default choice is random out of these with higher chances of "normal".}
}
\description{
The other options give are characteristics of the record (not the independent variables).
Warning: none of the other options work at the moment!
}
\seealso{
\code{\link[=autofill_rcrds]{autofill_rcrds()}}
}
