% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q-matrix.R
\name{extract_q_matrix}
\alias{extract_q_matrix}
\alias{extract_q_matrix.q_matrix}
\alias{extract_q_matrix.edina}
\alias{extract_q_matrix.default}
\title{Extract Q Matrix}
\usage{
extract_q_matrix(x, ...)

\method{extract_q_matrix}{q_matrix}(x, ...)

\method{extract_q_matrix}{edina}(x, binary = TRUE, ...)

\method{extract_q_matrix}{default}(x, ...)
}
\arguments{
\item{x}{An \code{edina} or \code{q_matrix} object}

\item{...}{Additional parameters}

\item{binary}{Boolean to indicate whether the \emph{Q} matrix is shown in
dichotomous form or in an estimated form.}
}
\value{
A \code{matrix} that is either dichotomous or estimated depending on the value
of the \code{binary} parameter.
}
\description{
Given a modeling object, extract the Q Matrix
}
\examples{
# Q matrix values
x = matrix(c(1, 0, 0, 1), nrow = 2)

# Show Q matrix structure
Q = q_matrix(x)

# Retrieve Q matrix
extract_q_matrix(Q)
}
\seealso{
\code{\link[=q_matrix]{q_matrix()}},
\code{\link[=as_q_matrix]{as_q_matrix()}},
\code{\link[=edina]{edina()}},
\code{\link[=auto_edina]{auto_edina()}}
}
