% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCueWeights.R
\name{plotCueWeights}
\alias{plotCueWeights}
\title{Visualize the change of connection weights between a specific cue and all 
outcomes.}
\usage{
plotCueWeights(
  wmlist,
  cue,
  select.outcomes = NULL,
  init.value = 0,
  add.labels = TRUE,
  add = FALSE,
  ...
)
}
\arguments{
\item{wmlist}{A list with weightmatrices, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}.}

\item{cue}{String: cue for which to extract the connection weights.}

\item{select.outcomes}{Optional selection of outcomes to limit the number 
of connection weights that are returned. The value of NULL (default) will 
return all connection weights. Note that specified values that are not in 
the weightmatrices will return the initial value without error or warning. 
Please use \code{\link{getOutcomes}} for returning all outcomes from the 
data, and \code{\link{getValues}} for returning all outcomes in the data.}

\item{init.value}{Value of connection weights for non-existing connections. 
Typically set to 0.}

\item{add.labels}{Logical: whether or not to add labels for the lines. 
Defaults to TRUE, see examples.}

\item{add}{Logical: whether or not to add the lines to an existing plot. 
Defaults to FALSE (starting a new plot).}

\item{...}{Optional graphical arguments, as specified in 
\code{\link[graphics]{par}}. These parameters are forwarded to the functions 
\code{\link[plotfunctions]{emptyPlot}}, \code{\link[graphics]{lines}}, and 
\code{\link[graphics]{text}}.}
}
\value{
Optionally a list with label specifications is returned, which 
allows to plot your own labels. This may be helpful for very long labels, 
and for overlapping lines.
}
\description{
Visualize the change of connection weights between a specific 
cue and all outcomes.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)
dim(dat)

# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)

# this training data can actually be used train network:
wm <- RWlearning(train)

# plot connection weights for cue = 'car':
plotCueWeights(wm, cue="car")

# plot your own labels:
labels <- plotCueWeights(wm, cue="car", add.labels=FALSE)
legend_margin('topright', legend=labels$labels, col=labels$col, 
    lwd=1, bty='n')

# change color and select outcomes:
out <- getValues(train$Outcomes, unique=TRUE)
out <- out[out != "vehicle"]
labels <- plotCueWeights(wm, cue="car", add.labels=FALSE, 
    col=alphaPalette(c(1,2), f.seq=rep(.5,length(out))), 
    select.outcomes=out)
lab2 <- plotCueWeights(wm, cue="car", add.labels=FALSE, 
    select.outcomes="vehicle", add=TRUE, col=1, lwd=2)
legend_margin('topright', legend=c(labels$labels, "vehicle"), 
    col=c(labels$col, lab2$col), lwd=c(labels$lwd, lab2$lwd), 
    lty=c(labels$lty, lab2$lty))

}
\seealso{
\code{\link{plotOutcomeWeights}}, \code{\link{getWeightsByOutcome}}, 
\code{\link{getWeightsByCue}}
}
\author{
Jacolien van Rij
}
