% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{rescale_binary}
\alias{rescale_binary}
\title{Rescale binary covariates as appropriate for edstan models}
\usage{
rescale_binary(x)
}
\arguments{
\item{x}{A numeric vector, matrix, or data frame}
}
\value{
A numeric vector, matrix, or data frame with rescaled covariates
  having mean of zero and range (maximum - minimum) of one.
}
\description{
This function rescales a covariate to have a mean of zero and range
(maximum - minimum) of one
}
\examples{
vec <- c(1, 3, 1, 3, 1)
rescale_binary(vec)

mat <- matrix(c(1, 3, 1, 3, 1), nrow = 5, ncol = 5)
rescale_binary(mat)
}
