% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfunctions.R
\name{plot.eefAnalytics}
\alias{plot.eefAnalytics}
\title{A plot method for an eefAnalytics S3 object obtained from the eefAnalytics package.}
\usage{
\method{plot}{eefAnalytics}(x, group, Conditional = TRUE, ES_Total = TRUE, slope = FALSE, ...)
}
\arguments{
\item{x}{an output object from the eefAnalytics package.}

\item{group}{a string/scalar value indicating which intervention to plot.
This must be one of the values of intervention variable excluding the control group.
For a two arm trial, the maximum number of values to consider is 1 and 2 for three arm trial.}

\item{Conditional}{a logical value to indicate whether to plot the conditional effect size.
The default is Conditional=TRUE, otherwise Conditional=FALSE should be specified for plot based on the unconditional effect size.
Conditional variance is total or residual variance from a multilevel model with fixed effects, whilst unconditional variance is total variance or residual variance from a multilevel model with only intercept as fixed effect.}

\item{ES_Total}{A logical value indicating whether to plot the effect size based on total variance or within school variance.
The default is ES_Total=TRUE, to plot the effect size using total variance.
ES_Total=FALSE should be specified for the effect size based on within school or residuals variance.}

\item{slope}{A logical value indicating whether to return the plot of random intercept (default is slope=FALSE).
return other school-by-intervention interaction random slope (s) is slope=TRUE.
This argument is suitable only for mstBayes and mstFREQ functions.}

\item{...}{arguments passed to \code{\link[graphics]{plot.default}}}
}
\value{
Returns relevant plots for each model.
}
\description{
Plots different figures based on output from eefAnalytics package.
}
\details{
Plot produces a graphical visualisation depending on which model is fitted:
\itemize{
\item For \code{srtFREQ()}, plot can only be used when \code{nBoot} or \code{nPerm} is specified to visualise the distribution of bootstrapped or permutated values.
\item For \code{crtFREQ()} or \code{mstFREQ()}, plot shows the distribution of random intercepts when \code{group=NULL}.
It produces histogram of permutated or bootstrapped values when \code{group} is specified and either \code{nBoot} or \code{nPerm} is also specified.
}
}
\examples{
if(interactive()){

#### read data
data(mstData)
data(crtData)


###############
##### SRT #####
###############

##### Bootstrapped

outputSRTBoot <- srtFREQ(Posttest~ Intervention + Prettest,
                         intervention = "Intervention",nBoot=1000, data = mstData)
plot(outputSRTBoot,group=1)

##### Permutation
outputSRTPerm <- srtFREQ(Posttest~ Intervention + Prettest,
                         intervention = "Intervention",nPerm=1000, data = mstData)

plot(outputSRTPerm,group=1)


###############
##### MST #####
###############


#### Random intercepts
outputMST <- mstFREQ(Posttest~ Intervention + Prettest,
                     random = "School", intervention = "Intervention", data = mstData)
plot(outputMST)


#### Bootstrapped
outputMSTBoot <- mstFREQ(Posttest~ Intervention + Prettest,
                         random = "School", intervention = "Intervention",
                         nBoot = 1000, data = mstData)

plot(outputMSTBoot)
plot(outputMSTBoot,group=1)

#### Permutation
outputMSTPerm <- mstFREQ(Posttest~ Intervention + Prettest,
                         random = "School", intervention = "Intervention",
                         nPerm = 1000, data = mstData)
plot(outputMSTPerm)
plot(outputMSTPerm,group=1)



###############
##### CRT #####
###############

#### Random intercepts
outputCRT <- crtFREQ(Posttest~ Intervention + Prettest, random = "School",
                     intervention = "Intervention", data = crtData)
plot(outputCRT)


## Bootstrapped
outputCRTBoot <- crtFREQ(Posttest~ Intervention + Prettest, random = "School",
                         intervention = "Intervention", nBoot = 1000, data = crtData)

plot(outputCRTBoot,group=1)


##Permutation
outputCRTPerm <- crtFREQ(Posttest~ Intervention + Prettest, random = "School",
                         intervention = "Intervention", nPerm = 1000, data = crtData)

plot(outputCRTPerm,group=1)
}
}
