% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpv_normalize.R
\name{rpv_normalize}
\alias{rpv_normalize}
\title{Normalize RPV results}
\usage{
rpv_normalize(ei_object, cand_cols, race_cols)
}
\arguments{
\item{ei_object}{Output from \code{ei_iter()} or \code{ei_rxc()}}

\item{cand_cols}{A character vector of the candidate column names to be 
normalized from \code{ei_object}. Only use candidate column name columns, 
not the No Vote column.}

\item{race_cols}{A character vector of the racial group column names to
be normalized from \code{ei_object}}
}
\value{
Normalized RPV results in a data.frame
}
\description{
Create a dataframe of normalized RPV results when using the 
cvap, vap, or bisg denominator method, i.e., take RPV results only among 
people estimated to have voted.
}
\examples{
\donttest{
#library(eiExpand)
#data("south_carolina")
#prec_election_demog <- south_carolina[1:50,]

## run rpv using eiCompare (rxc method)
#rxcVote <-  eiCompare::ei_rxc(
#  data = prec_election_demog,
#  cand_cols = c('pct_mcmaster', 'pct_smith', 'pct_other_gov', 'pct_NoVote_gov'),
#  race_cols = c('pct_white', 'pct_black', 'pct_race_other'),
#  totals_col = "total_vap")

## normalize results accounting for no vote using rpv_normalize()
## only include the candidate and race cols of interest for the rpv analysis
#rpv_results <- rpv_normalize(
 # ei_object = rxcVote,
 # cand_cols = c('pct_mcmaster', 'pct_smith', 'pct_other_gov'), 
 # race_cols = c('pct_white', 'pct_black')
#)
}
}
\author{
Rachel Carroll <rachelcarroll4@gmail.com>

Loren Collingwood <lcollingwood@unm.edu>
}
