% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAST.R
\name{CAST.calc.sample}
\alias{CAST.calc.sample}
\title{Construct a sample for auditing using CAST}
\usage{
CAST.calc.sample(
  Z,
  beta = 0.9,
  stages = 1,
  t = 3,
  as.taint = FALSE,
  small.cut = NULL,
  strata = NULL,
  drop = NULL,
  method = c("select", "binomial", "hypergeometric"),
  calc.e.max = TRUE,
  bound.function = maximumMarginBound
)
}
\arguments{
\item{Z}{elec.data object (voter matrix)}

\item{beta}{the confidence level desired - overall chance of correctly escalating a bad election to full recount}

\item{stages}{number of auditing stages. Each stage will have the same
confidence level, determined by a function of beta.  A value of 1 is a
single-stage audit.}

\item{t}{The maximum amount of error, in votes, expected. Threshold error for escalation -- if >= 1 then number of votes, otherwise
fraction of margin.}

\item{as.taint}{Boolean value.  TRUE means interpret $t$ as a taint in
$[0,1]$ by batch (so the threshold error will be batch-specific).  FALSE
means interpret $t$ as a proportion of the margin or as number of votes (as
described above).}

\item{small.cut}{Cut-off in votes--any precincts with potential error
smaller than this value will not be audited and be assumed to be worst case
error.}

\item{strata}{Name of the stratification column of Z.  Not needed if audit
plan also being passed in case of CAST.sample. NULL means single strata.}

\item{drop}{Vector of precincts to drop for whatever reasons (such as they
are already known).  This is a vector of TRUE/FALSE.}

\item{method}{Method of calculation.}

\item{calc.e.max}{Should the e.max be taken as given, or recalculated?}

\item{bound.function}{What function should be used to calculate worst-case
potential error of precincts.}
}
\description{
Collection of functions for planning and evaluating results of a CAST
election audit.  CAST is a system devised by Dr. Philip B., Stark, UC
Berkeley Department of Statistics.

\code{CAST.calc.sample} determines what size SRS sample should be drawn to
have a reasonable chance of certification if the election does not have
substantial error.  It returns an \code{audit.plan}. \code{CAST.sample}
takes the audit.plan and draws a sample to audit. \code{CAST.audit} takes
audit data (presumably from the audit of the sample drawn in previous step)
and analyzes it.

Make an audit.plan given reported results for an election.  It gives back what to
do for a single stage.  If stages is > 1, then it adjusts beta appropriately.
}
\examples{

        ## Make an example cartoon race (from Stark paper)
	Z = make.cartoon()

        ## What should we do?
	samp.info = CAST.calc.sample( Z )
	samp.info

        ## Draw a sample.
	samp = CAST.sample( Z, samp.info$ns )
        samp

        ## Analyze what a CAST audit of santa cruz would entail
        data(santa.cruz)
        Z = elec.data( santa.cruz, C.names=c("leopold","danner") )
        CAST.calc.sample( Z, beta=0.75, stages=1, t=5, small.cut=60)
}
\references{
Philip B. Stark. CAST: Canvass Audits by Sampling and Testing.
University of California at Berkeley Department of Statistics, 2009. URL:
http://statistics.berkeley.edu/~stark/Preprints/cast09.pdf.  Also see
http://www.stat.berkeley.edu/~stark/Vote/index.htm for other relevant
information.
}
\seealso{
\code{\link{elec.data}} for a description of the object that holds
precinct-level vote records.  See \code{\link{tri.calc.sample}} for a PPEB
auditing method.  See \code{\link{CAST.calc.opt.cut}} for calculating
optimal cut-offs to keep needed sample size low. Also see
\code{\link{sim.race}}, \code{\link{do.audit}}, \code{\link{make.sample}},
and \code{\link{make.truth}} for doing simulation studies of this method.
}
\author{
Luke W. Miratrix
}
