#' Download data on the verification of federal elections in Brazil
#'
#' \code{details_mun_zone_fed()} downloads and aggregates data on the verification of federal elections in Brazil,
#' disaggregated by town and electoral zone. The function returns a \code{data.frame} where each observation
#' corresponds to a town/zone.
#'
#' @note For the elections prior to 2002, some information can be incomplete. For the 2014, 2018, and 2022 elections, more variables are available.
#'
#' @param year Election year. For this function, only the years 1994, 1998, 2002, 2006, 2010, 2014, 2018, and 2022
#' are available.
#' 
#' @param uf Federation Unit acronym (\code{character vector}).
#' 
#' @param br_archive In the TSE's data repository, some results can be obtained for the whole country by loading a single
#' within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
#' other, it recovers only electoral data for presidential elections, absent in other files).
#'
#' @param encoding Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
#' when \code{ascii = TRUE}.
#' 
#' 
#' @param temp (\code{logical}). elections_rda
#'
#' @details If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
#'  files in the current directory.
#'
#' @return \code{details_mun_zone_fed()} returns a \code{data.frame} with the following variables:
#'
#' @import utils
#' @importFrom magrittr "%>%"
#' @export
#' @examples
#' \dontrun{
#' df <- details_mun_zone_fed(2002)
#' }

details_mun_zone_fed <- function(year,
                                 uf = "all", 
                                 br_archive = FALSE, 
                                 encoding = "latin1",
                                 temp = TRUE){


  .Deprecated("elections_tse", msg = "details_mun_zone_fed is deprecated and will no longer be supported in electionsBR 1.0.0. Please use the elections_tse function")
  
  answer <- details_mun_zone(year,
                              uf, 
                              br_archive,
                              encoding,
                             temp)
  return(answer)
}
