% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voter_profile_by_section.R
\name{voter_profile_by_section}
\alias{voter_profile_by_section}
\title{Download data on the voters' profile by vote section}
\usage{
voter_profile_by_section(
  year,
  uf = "AC",
  encoding = "windows-1252",
  temp = TRUE,
  readme_pdf = FALSE
)
}
\arguments{
\item{year}{Election year (\code{integer}). For this function, the following years are available:  2008, 2010, 2012, 2014, 2016, 2018, 2020, 2022 and 2024.}

\item{uf}{Federation Unit acronym (\code{character vector}). Defaults to \code{'AC'} (Acre).}

\item{encoding}{Data original encoding (defaults to 'windows-1252'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE}, keep the temporary compressed file for future use (recommended)}

\item{readme_pdf}{original readme}
}
\value{
\code{voter_profile()} returns a \code{data.frame} with the following variables:
}
\description{
\code{voter_profile_by_section()} downloads and cleans data on the voters' profile aggregated by voting section (i.e., voting stations).
The function returns a \code{data.frame} where each observation corresponds to a voter profile type.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\examples{
\dontrun{
df <- voter_profile_by_section(2016)
}
}
