% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidate_local.R
\name{candidate_local}
\alias{candidate_local}
\title{Download data on the candidates' background in local elections}
\usage{
candidate_local(year, uf = "all", encoding = "latin1", temp = TRUE)
}
\arguments{
\item{year}{Election year. For this function, only the years of 1996, 2000, 2004, 2008, 2012, 2016, 2020, and 2024
are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{encoding}{Data original encoding (defaults to 'latin1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). elections_rda}
}
\value{
\code{candidate_local()} returns a \code{data.frame} with the following variables:
}
\description{
\code{candidate_local()} downloads and aggregates the data on the candidates' background who competed in the
local elections in Brazil. The function returns a \code{data.frame} where each observation
corresponds to a candidate.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2000, some information can be incomplete.
}
\examples{
\dontrun{
df <- candidate_local(2000)
}
}
