% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elfchange.R
\name{elfchange}
\alias{elfchange}
\title{Plot percent richness change for various percent flow reductions}
\usage{
elfchange(stats, yaxis_thresh, xlabel = FALSE, ylabel = FALSE)
}
\arguments{
\item{stats}{A dataframe of ELF statistics}

\item{yaxis_thresh}{Value used for specifying y-axis max limit}

\item{xlabel}{Used to overwrite default x-axis label}

\item{ylabel}{Used to overwrite default y-axis label}
}
\value{
Plot of percent decreases in richness from flow reductions
}
\description{
Calculates and plots percent richness change resulting from streamflow reductions
}
\examples{
\donttest{
# We don't run this example by R CMD check, because it takes >10s

# Generate plot of percent richness change for various percent flow reductions
watershed.df <- elfdata(watershed.code = '0208020104',
 ichthy.localpath = tempdir(), use_cache = FALSE)
breakpt <- 500
elf <- elfgen(
   "watershed.df" = watershed.df,
   "quantile" = 0.95,
   "breakpt" = breakpt,
   "xlabel" = "Mean Annual Flow (ft3/s)",
   "ylabel" = "Fish Species Richness"
   )
elfchange(elf$stats, "yaxis_thresh" = 25)
}
}
