% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{elixir}
\alias{elixir}
\title{\code{elixir}: Transmutation of languages}
\description{
\code{elixir} is a set of tools for transforming R expressions, including
into other programming languages.
}
\details{
One of the neat features of R is that you can use the language to
inspect itself. Expressions, functions, indeed entire R scripts can be
examined and manipulated just like any list, data.frame, or other R
object.

However, the syntax for manipulating R language objects is a little
tricky. Packages such as \code{rlang} help to make this task easier. \code{elixir}
makes a few extra shortcuts available, and is geared for advanced R
users.

\code{elixir} provides functions for finding, extracting, and replacing patterns
in 'R' language objects, similarly to how regular expressions can be used to
find, extract, and replace patterns in text. It also provides functions for
generating code using specially-formatted template files and for translating
'R' expressions into similar expressions in other programming languages.

The package may be helpful for advanced uses of 'R' expressions, such as
developing domain-specific languages.
}
\section{Find and replace for language objects}{


Sometimes you want to detect certain patterns within an expression or
list of expressions, or easily replace a certain pattern with another.
When working with strings, regular expressions are a handy way of
accomplishing such tasks. \code{elixir} provides a sort of "regular
expressions for R expressions" functionality through the functions
\code{\link[=expr_match]{expr_match()}}, \code{\link[=expr_replace]{expr_replace()}}, and the "shortcut" functions
\code{\link[=expr_count]{expr_count()}}, \code{\link[=expr_detect]{expr_detect()}}, \code{\link[=expr_extract]{expr_extract()}}, and \code{\link[=expr_locate]{expr_locate()}}.
}

\section{Other \code{elixir} features}{


The function \code{\link[=expr_apply]{expr_apply()}} allows you to transform and extract information
from nested list structures which contain expressions, so if you have a big
structure and you want to check all the variable names or make certain
replacements, this may be useful.

\code{\link[=expr_sub]{expr_sub()}} offers an interface for extracting or replacing part of an
expression; the one advantage this has over \code{[[} is that it allows you to use
\code{NULL} as the index, which gives back the whole expression.

\code{\link[=lang2str]{lang2str()}} does the opposite of \code{\link[base:parse]{base::str2lang()}}; it is like
\code{deparse1()} which is new since R 4.0.0, but with \code{collapse = ""} instead of
\code{collapse = " "}.

Finally, \code{\link[=meld]{meld()}}, \code{\link[=translate]{translate()}}, and \code{\link[=reindent]{reindent()}} are various experimental
functions for constructing code using R.
}

