% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-perplexity.R
\name{chat_perplexity}
\alias{chat_perplexity}
\title{Chat with a model hosted on perplexity.ai}
\usage{
chat_perplexity(
  system_prompt = NULL,
  base_url = "https://api.perplexity.ai/",
  api_key = NULL,
  credentials = NULL,
  model = NULL,
  params = NULL,
  api_args = list(),
  echo = NULL,
  api_headers = character()
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{base_url}{The base URL to the endpoint; the default is OpenAI's
public API.}

\item{api_key}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{credentials} instead.}

\item{credentials}{Override the default credentials. You generally should not need this argument; instead set the \code{PERPLEXITY_API_KEY} environment variable. The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.

If you do need additional control, this argument takes a zero-argument function that returns either a string (the API key), or a named list (added as additional headers to every request).}

\item{model}{The model to use for the chat (defaults to "llama-3.1-sonar-small-128k-online").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}
}
\value{
A \link{Chat} object.
}
\description{
Sign up at \url{https://www.perplexity.ai}.

Perplexity AI is a platform for running LLMs that are capable of
searching the web in real-time to help them answer questions with
information that may not have been available when the model was
trained.

This function is a Uses OpenAI compatible API via \code{chat_openai_compatible()} with
the defaults tweaked for Perplexity AI.
}
\examples{
\dontrun{
chat <- chat_perplexity()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openai_compatible}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
