% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-claude-tools.R
\name{claude_tool_web_fetch}
\alias{claude_tool_web_fetch}
\title{Claude web fetch tool}
\usage{
claude_tool_web_fetch(
  max_uses = NULL,
  allowed_domains = NULL,
  blocked_domains = NULL,
  citations = FALSE,
  max_content_tokens = NULL
)
}
\arguments{
\item{max_uses}{Integer. Maximum number of fetches allowed per request.}

\item{allowed_domains}{Character vector. Restrict fetches to specific domains.
Cannot be used with \code{blocked_domains}.}

\item{blocked_domains}{Character vector. Exclude specific domains from fetches.
Cannot be used with \code{allowed_domains}.}

\item{citations}{Logical. Whether to include citations in the response. Default is \code{TRUE}.}

\item{max_content_tokens}{Integer. Maximum number of tokens to fetch from each URL.}
}
\description{
Enables Claude to fetch and analyze content from web URLs. Claude can only
fetch URLs that appear in the conversation context (user messages or
previous tool results). For security reasons, Claude cannot dynamically
construct URLs to fetch.

Requires the \code{web-fetch-2025-09-10} beta header.
Learn more in \url{https://docs.claude.com/en/docs/agents-and-tools/tool-use/web-fetch-tool}.
}
\examples{
\dontrun{
chat <- chat_claude(beta_headers = "web-fetch-2025-09-10")
chat$register_tool(claude_tool_web_fetch())
chat$chat("What are the latest package releases on https://tidyverse.org/blog")
}
}
\seealso{
Other built-in tools: 
\code{\link{claude_tool_web_search}()},
\code{\link{google_tool_web_fetch}()},
\code{\link{google_tool_web_search}()},
\code{\link{openai_tool_web_search}()}
}
\concept{built-in tools}
