#' logLik.tsd Return Log Likelihood of a fit
#' @title Return Log Likelihood of a fit generated by tsd
#' @author Marc Girondot
#' @return The Log Likelihood value of the fitted model and data
#' @param object A result file generated by tsd
#' @param ... Not used
#' @description Return Log Likelihood of a fit generated by tsd. The object has 3 attributes:\cr
#' nall, and nobs the number of observations, df, the number of fitted parameters.
#' @examples
#' \dontrun{
#' library(embryogrowth)
#' m <- c(10, 14, 7, 4, 3, 0, 0)
#' f <- c(0, 1, 2, 4, 15, 10, 13)
#' t <- c(25, 26, 27, 28, 29, 30, 31)
#' result <- tsd(males=m, females=f, temperatures=t)
#' logLik(result)
#' AIC(result)
#' }
#' @method logLik tsd
#' @export


logLik.tsd <- function(object, ...) {
  l <- -object$value
  attributes(l) <- list(nall=length(unique(object$temperatures)) , nobs=length(unique(object$temperatures)), 
  	df=length(object$par) , class="logLik")
  return(l)
}
