% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hfit.R
\docType{methods}
\name{hfit}
\alias{hfit}
\alias{hfit,hspec-method}
\title{Perform Maximum Likelihood Estimation}
\usage{
hfit(
  object,
  inter_arrival = NULL,
  type = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  lambda_component0 = NULL,
  N0 = NULL,
  mylogLik = NULL,
  reduced = TRUE,
  grad = NULL,
  hess = NULL,
  constraint = NULL,
  method = "BFGS",
  verbose = FALSE,
  ...
)

\S4method{hfit}{hspec}(
  object,
  inter_arrival = NULL,
  type = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  lambda_component0 = NULL,
  N0 = NULL,
  mylogLik = NULL,
  reduced = TRUE,
  grad = NULL,
  hess = NULL,
  constraint = NULL,
  method = "BFGS",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{\link{hspec-class}} object containing the parameter values.}

\item{inter_arrival}{A vector of inter-arrival times for events across all dimensions, starting with zero.}

\item{type}{A vector indicating the dimensions, represented by numbers like 1, 2, 3, etc., starting with zero.}

\item{mark}{A vector of mark (jump) sizes, starting with zero.}

\item{N}{A matrix representing counting processes.}

\item{Nc}{A matrix of counting processes weighted by mark sizes.}

\item{lambda_component0}{Initial values for the lambda component \eqn{\lambda_{ij}}.
Can be a numeric value or a matrix.
Must have the same number of rows and columns as \code{alpha} or \code{beta} in \code{object}.}

\item{N0}{Initial values for the counting processes matrix \code{N}.}

\item{mylogLik}{A user-defined log-likelihood function, which must accept an \code{object} argument consistent with \code{object}.}

\item{reduced}{Logical; if \code{TRUE}, performs reduced estimation.}

\item{grad}{A gradient matrix for the likelihood function. Refer to \code{\link[maxLik]{maxLik}} for more details.}

\item{hess}{A Hessian matrix for the likelihood function. Refer to \code{\link[maxLik]{maxLik}} for more details.}

\item{constraint}{Constraint matrices. Refer to \code{\link[maxLik]{maxLik}} for more details.}

\item{method}{The optimization method to be used. Refer to \code{\link[maxLik]{maxLik}} for more details.}

\item{verbose}{Logical; if \code{TRUE}, prints the progress of the estimation process.}

\item{...}{Additional parameters for optimization. Refer to \code{\link[maxLik]{maxLik}} for more details.}
}
\value{
\code{\link[maxLik]{maxLik}} object
}
\description{
This is a generic function named \code{hfit} designed for estimating the parameters
of the exponential Hawkes model. It is implemented as an S4 method for two main reasons:
}
\details{
Model Representation: To represent the structure of the model as an \code{hspec} object.
The multivariate marked Hawkes model has numerous variations, and using an S4 class
allows for a flexible and structured approach.

Optimization Initialization: To provide a starting point for numerical optimization.
The parameter values assigned to the \code{hspec} slots serve as initial values for the optimization process.

This function utilizes the \code{\link[maxLik]{maxLik}} package for optimization.
}
\examples{

# example 1
mu <- c(0.1, 0.1)
alpha <- matrix(c(0.2, 0.1, 0.1, 0.2), nrow=2, byrow=TRUE)
beta <- matrix(c(0.9, 0.9, 0.9, 0.9), nrow=2, byrow=TRUE)
h <- new("hspec", mu=mu, alpha=alpha, beta=beta)
res <- hsim(h, size=100)
summary(hfit(h, inter_arrival=res$inter_arrival, type=res$type))


# example 2
\donttest{
mu <- matrix(c(0.08, 0.08, 0.05, 0.05), nrow = 4)
alpha <- function(param = c(alpha11 = 0, alpha12 = 0.4, alpha33 = 0.5, alpha34 = 0.3)){
  matrix(c(param["alpha11"], param["alpha12"], 0, 0,
           param["alpha12"], param["alpha11"], 0, 0,
           0, 0, param["alpha33"], param["alpha34"],
           0, 0, param["alpha34"], param["alpha33"]), nrow = 4, byrow = TRUE)
}
beta <- matrix(c(rep(0.6, 8), rep(1.2, 8)), nrow = 4, byrow = TRUE)

impact <- function(param = c(alpha1n=0, alpha1w=0.2, alpha2n=0.001, alpha2w=0.1),
                   n=n, N=N, ...){

  Psi <- matrix(c(0, 0, param['alpha1w'], param['alpha1n'],
                  0, 0, param['alpha1n'], param['alpha1w'],
                  param['alpha2w'], param['alpha2n'], 0, 0,
                  param['alpha2n'], param['alpha2w'], 0, 0), nrow=4, byrow=TRUE)

  ind <- N[,"N1"][n] - N[,"N2"][n] > N[,"N3"][n] - N[,"N4"][n] + 0.5

  km <- matrix(c(!ind, !ind, !ind, !ind,
                 ind, ind, ind, ind,
                 ind, ind, ind, ind,
                 !ind, !ind, !ind, !ind), nrow = 4, byrow = TRUE)

  km * Psi
}
h <- new("hspec",
         mu = mu, alpha = alpha, beta = beta, impact = impact)
hr <- hsim(h, size=100)
plot(hr$arrival, hr$N[,'N1'] - hr$N[,'N2'], type='s')
lines(hr$N[,'N3'] - hr$N[,'N4'], type='s', col='red')
fit <- hfit(h, hr$inter_arrival, hr$type)
summary(fit)
}

# example 3
\donttest{
mu <- c(0.15, 0.15)
alpha <- matrix(c(0.75, 0.6, 0.6, 0.75), nrow=2, byrow=TRUE)
beta <- matrix(c(2.6, 2.6, 2.6, 2.6), nrow=2, byrow=TRUE)
rmark <- function(param = c(p=0.65), ...){
  rgeom(1, p=param[1]) + 1
}
impact <- function(param = c(eta1=0.2), alpha, n, mark, ...){
  ma <- matrix(rep(mark[n]-1, 4), nrow = 2)
  alpha * ma * matrix( rep(param["eta1"], 4), nrow=2)
}
h1 <- new("hspec", mu=mu, alpha=alpha, beta=beta,
          rmark = rmark,
          impact=impact)
res <- hsim(h1, size=100, lambda_component0 = matrix(rep(0.1,4), nrow=2))

fit <- hfit(h1,
            inter_arrival = res$inter_arrival,
            type = res$type,
            mark = res$mark,
            lambda_component0 = matrix(rep(0.1,4), nrow=2))
summary(fit)
}
# For more information, please see vignettes.
}
\seealso{
\code{\link{hspec-class}}, \code{\link{hsim,hspec-method}}
}
