% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descargar.inei.R
\name{descargar.inei}
\alias{descargar.inei}
\title{Descargar}
\usage{
descargar.inei(
  encuesta = "ENAHO",
  modulo,
  periodos,
  dirdescarga = getwd(),
  tipo = "anual",
  ensilencio = FALSE
)
}
\arguments{
\item{encuesta}{el nombre de una encuesta del INEI. Las opciones dispobibles son
\code{"ENAHO"}, \code{"ENAHOpanel"} y \code{"ENDES"}. No importa si está escrito en mayúscula o minúscula.}

\item{modulo}{el código del módulo deseado.}

\item{periodos}{los años deseados.}

\item{dirdescarga}{el directorio de descarga.}

\item{tipo}{el tipo de período deseado. Las opciones son \code{"anual"},
  \code{"t1"} (primer trimestre),
  \code{"t2"} (segundo trimestre),
  \code{"t3"} (tercer trimestre),
y \code{"t4"} (cuarto trimestre). Las opciones pueden combinarse.}

\item{ensilencio}{un valor lógico que indica si el progreso de la función debe ser omitido.}
}
\value{
guarda los archivos descargados en el disco.
}
\description{
Descarga datos disponibles del portal de Microdatos del INEI.
}
\examples{
descargar.inei(modulo = 37, periodos = 2011, dirdescarga = tempdir(), tipo = "t1")

}
