% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt.R
\name{encrypt}
\alias{encrypt}
\title{Encrypt a data frame or tibble column using an RSA public/private key}
\usage{
encrypt(
  .data,
  ...,
  public_key_path = "id_rsa.pub",
  lookup = FALSE,
  lookup_name = "lookup",
  write_lookup = TRUE
)
}
\arguments{
\item{.data}{A data frame or tibble.}

\item{...}{The unquoted names of columns to encrypt.}

\item{public_key_path}{Character. A quoted path to an RSA public key created
using \code{\link{genkeys}}.}

\item{lookup}{Logical. Whether to substitute the encrypted columns for
key-column of integers.}

\item{lookup_name}{Character. A quoted name to give lookup table and file.}

\item{write_lookup}{Logical. Write a lookup table as a .csv file.}
}
\value{
The original dataframe or tibble with the specified columns
  encrypted.
}
\description{
Encrypt a data frame or tibble column using an RSA public/private key
}
\examples{
# This will run:
# genkeys()
# gp_encrypt = gp \%>\%
#   select(-c(name, address1, address2, address3)) \%>\%
#   encrypt(postcode, telephone)

# For CRAN and testing:
library(dplyr)
temp_dir = tempdir()
genkeys(file.path(temp_dir, "id_rsa2")) # temp directory for testing only
gp_encrypt = gp \%>\%
  select(-c(name, address1, address2, address3)) \%>\%
  encrypt(postcode, telephone, public_key_path = file.path(temp_dir, "id_rsa2.pub"))
}
