% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_formulas.R
\name{get_formulas}
\alias{get_formulas}
\alias{get_formulas_main}
\alias{aux_var_comb}
\alias{aux_string_comb}
\title{Get GLM formulas according to defined response types}
\usage{
get_formulas(dependent, independent, type = "l", mode = "moderate",
             minvar = 1, maxvar = NULL)

get_formulas_main(dependent, independent, type = "l",
                  complex = FALSE, minvar = 1, maxvar = NULL)

aux_var_comb(var_names, minvar = 2, maxvar = NULL)

aux_string_comb(string)
}
\arguments{
\item{dependent}{(character) name of dependent variable.}

\item{independent}{(character) vector of name(s) of independent variable(s).}

\item{type}{(character) a character string that must contain "l",
"p", "q" or a combination of them. l = lineal, q = quadratic,
p = interaction between two variables. Default = "l".}

\item{mode}{(character) (character) a character string to indicate the strategy to
create the formulas for candidate models. Options are: "light", "moderate",
"intensive", or "complex". Default = "moderate".}

\item{minvar}{(numeric) minimum number of independent variables in formulas.}

\item{maxvar}{(numeric) maximum number of independent variables in formulas.}

\item{complex}{(logical) whether to return the most complex formula.}

\item{var_names}{sames as \code{independent}.}

\item{string}{same as \code{type}.}
}
\value{
A character vector containing the resulting formula(s).
}
\description{
Generate GLM formulas for independent variables predicting a dependent
variable, taking into account response types required. All possible
combinations of variables can be created using arguments of the function.
}
\details{
\code{mode} options determine what strategy to iterate the predictors
defined in \code{type} for creating models:
\itemize{
\item \strong{light}.-- returns simple iterations of complex formulas.
\item \strong{moderate}.-- returns a comprehensive number of iterations.
\item \strong{intensive}.-- returns all possible combination. Very time-consuming for
6 or more independent variables.
\item \strong{complex}.-- returns only the most complex formula.
}
}
\examples{
# example variables
dep <- "sp"
ind <- c("temp", "rain", "slope")

# The most complex formula according to "type"
get_formulas(dep, ind, type = "lqp", mode = "complex")

# mode = 'light', combinations according to type
get_formulas(dep, ind, type = "lqp", mode = "light")

# mode = 'light', combinations according to type
get_formulas(dep, ind, type = "lqp", mode = "intensive")
}
