% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographics.R
\name{get_occupation_data}
\alias{get_occupation_data}
\title{Auxiliary function to obtain the information of the occupations}
\usage{
get_occupation_data(
  valid_codes,
  isco_codes,
  isco88_table,
  name_occupation,
  sex = NULL
)
}
\arguments{
\item{valid_codes}{A numeric vector with the valid codes from the ISCO-88
table}

\item{isco_codes}{A numeric vector of ISCO-88 occupation codes
(major, submajor, minor, or unit)}

\item{isco88_table}{The ISCO-88 table columns of the information for that
group of occupations}

\item{name_occupation}{The category of occupations to be consulted. These can
be: major, submajor, minor, or unit}

\item{sex}{A vector with the respective sex for isco_codes vector. The
default value is NULL}
}
\value{
A dataframe with the information of the occupations
}
\description{
Auxiliary function to obtain the information of the occupations
}
\keyword{internal}
