% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dict.R
\name{read_dict}
\alias{read_dict}
\title{Data dictionaries}
\usage{
read_dict(
  path,
  sheet,
  format,
  tibble = TRUE,
  long = TRUE,
  compact = TRUE,
  clean = TRUE
)
}
\arguments{
\item{path}{Define the path to .xlsx file where the dictionary is stored}

\item{sheet}{Optional, if your sheets have non-standard names
(e.g. using a disease pre-fix) - this can be specified here.}

\item{format}{The format which the dictionary is in. Currently supports
"DHIS2" and "ODK".}

\item{tibble}{If \code{TRUE} (default), return data dictionary as a
tidyverse tibble otherwise will return a list.}

\item{long}{If \code{TRUE} (default), the returned data dictionary is in long
format with each option getting one row. If \code{FALSE}, then two data frames
are returned, one with variables and the other with content options.}

\item{compact}{If \code{TRUE} (default), then a nested data frame is returned
where each row represents a single variable and a nested data frame column
called "options", which can be expanded with \code{\link[tidyr:unnest]{tidyr::unnest()}}. This only
works if \code{long = TRUE}.}

\item{clean}{If \code{TRUE} (default), then will clean variable names and variable options.
This will set text to lower snake case and remove any accents.}
}
\value{
If \code{long = TRUE}, returns a tibble of the merged dictionary and
value options. If \code{long = FALSE}, returns a list with elements \code{dictionary}
and \code{options}. If \code{compact = TRUE}, options are nested as a column of
data frames under "options".
}
\description{
These function read dictionaries in ODK and DHIS2  formats, and reformats them
for dataset recoding into human-readable format.
}
