% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_param.R
\name{.extract_param}
\alias{.extract_param}
\title{Optimises the parameters for a specified probability distribution given the
percentiles of a distribution and the values at those percentiles, or the
median and range of a sample and the number of samples.}
\usage{
.extract_param(values, distribution, percentiles, samples)
}
\arguments{
\item{values}{A \code{vector}. If \code{type = percentiles}: \code{c(percentile_1, percentile_2)}; and if \code{type = range}: \code{c(median, min, max)}.}

\item{distribution}{A \code{character} specifying distribution to use.
Default is \code{lnorm}; also takes \code{gamma}, \code{weibull} and \code{norm}.}

\item{percentiles}{A \code{vector} with two elements specifying the
percentiles defined in \code{values} if using \code{type = "percentiles"}.
Percentiles should be specified between 0 and 1. For example 2.5th and 97.5th
percentile is given as \code{c(0.025, 0.975)}.}

\item{samples}{A \code{numeric} specifying the sample size if using
\code{type = "range"}.}
}
\value{
A list with output from \code{\link[stats:optim]{stats::optim()}}.
}
\description{
Optimises the parameters for a specified probability distribution given the
percentiles of a distribution and the values at those percentiles, or the
median and range of a sample and the number of samples.
}
\keyword{internal}
