% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter.R
\name{is_epiparameter}
\alias{is_epiparameter}
\title{Check object is an \verb{<epiparameter>}}
\usage{
is_epiparameter(x)
}
\arguments{
\item{x}{An \R object.}
}
\value{
A boolean logical, \code{TRUE} if the object is an \verb{<epiparameter>}
and \code{FALSE} if not.
}
\description{
Check object is an \verb{<epiparameter>}
}
\examples{
ep <- epiparameter(
  disease = "ebola",
  epi_name = "serial_interval",
  prob_distribution = create_prob_distribution(
    prob_distribution = "gamma",
    prob_distribution_params = c(shape = 1, scale = 1)
  )
)

is_epiparameter(ep)

false_ep <- list(
  disease = "ebola",
  epi_name = "serial_interval",
  prob_distribution = "gamma",
  prob_distribution_params = c(shape = 1, scale = 1)
)

is_epiparameter(false_ep)
}
