% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{create_report_monthly_avgs}
\alias{create_report_monthly_avgs}
\title{Create monthly averages report}
\usage{
create_report_monthly_avgs(data, diseases, config)
}
\arguments{
\item{data}{Dataframe. Input data with columns:
\itemize{
\item \code{disease} (character)
\item \code{year} (integer)
\item \code{month} (integer)
\item \code{counts} (integer)
}}

\item{diseases}{Character vector. Diseases to include in the report}

\item{config}{List. Report settings}
}
\value{
Dataframe of monthly averages with one row per disease and one column
per month (Jan through Dec).
}
\description{
'create_report_monthly_avgs' generates a data frame of average monthly case
counts for each disease across all years in the input data.
}
\details{
Uses the following config options:
\itemize{
\item \code{rounding_decimals}
}
}
\examples{
data <- data.frame(
  disease = c("A", "A", "B", "B"),
  year = c(2023, 2024, 2023, 2024),
  month = c(1, 1, 2, 2),
  counts = c(10, 20, 15, 25)
)
config <- list(rounding_decimals = 1)
create_report_monthly_avgs(data, c("A", "B", "C"), config)
}
\seealso{
\code{\link[=epitraxr_config]{epitraxr_config()}} for config options
}
