% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\name{write_report_csv}
\alias{write_report_csv}
\title{Write report CSV files}
\usage{
write_report_csv(data, filename, folder)
}
\arguments{
\item{data}{Dataframe. Report data.}

\item{filename}{String. Report filename.}

\item{folder}{Filepath. Report destination folder.}
}
\value{
NULL.
}
\description{
\code{write_report_csv} writes the given data to the specified folder with the
given filename.
}
\examples{
# Create sample data
r_data <- data.frame(
  Disease = c("Measles", "Chickenpox"),
  Counts = c(20, 43)
)

# Write to temporary directory
write_report_csv(r_data, "report.csv", tempdir())
unlink(file.path(tempdir(), "report.csv"), recursive = TRUE)
}
