% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.pchc}
\alias{.pchc}
\title{Wrapper to determine Paretian Classification of Health Change}
\usage{
.pchc(df, level_fu_1, add_noprobs = FALSE)
}
\arguments{
\item{df}{A data frame with EQ-5D states and follow-up variable. The dataset is assumed to be have been ordered correctly.}

\item{level_fu_1}{Value of the first (i.e. earliest) follow-up. Would normally be defined as levels_fu[1].}

\item{add_noprobs}{Logical value indicating whether to include a separate classification for those without problems (default is FALSE)}
}
\value{
A data frame with PCHC value for each combination of the grouping variables. 
If 'add_noprobs' is TRUE, a separate classification for those without problems is also included.
}
\description{
This internal function determines Paretian Classification of Health Change (PCHC) for each combination of the variables specified in the `group_by` argument. 
It is used in the code for table_2_4-table_2_5 and figure_2_1-figure_2_4. 
An EQ-5D health state is deemed to be `better` than another if it is better on at least one dimension and is no worse on any other dimension.
An EQ-5D health state is deemed to be `worse` than another if it is worse in at least one dimension and is no better in any other dimension.
}
\examples{
df <- data.frame(id = c(1, 1, 2, 2),
                 fu = c(1, 2, 1, 2),
                 mo = c(1, 1, 1, 1),
                 sc = c(1, 1, 5, 1),
                 ua = c(1, 1, 4, 3),
                 pd = c(1, 1, 1, 3),
                 ad = c(1, 1, 1, 1))
.pchc(df, level_fu_1 = 1, add_noprobs = TRUE)
}
